# Night Mode by FriendsOfFlarum

[![GitHub license](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/fof/nightmode/blob/master/LICENSE)
[![Latest Stable Version](https://img.shields.io/packagist/v/fof/nightmode.svg)](https://github.com/FriendsOfFlarum/nightmode)
[![Total Downloads](https://img.shields.io/packagist/dt/fof/nightmode.svg)](https://packagist.org/packages/fof/nightmode)

A [Flarum](http://flarum.org) extension. Add a Night Mode 🌙 for your users to use on your Flarum forum! (THE LIGHT 🌞, IT BUUUURNSSS!!!)
- A new "Night Mode" menu option will appear in your user options when you click on your avatar next to the notifications icon.
![Night Mode Option](https://i.imgur.com/x3Cvhic.png)
- A "Day Mode" option has been added as well to make the light appear again! (BEGONE, DANKESS!)
![Day Mode Option](https://i.imgur.com/ZJcDGQB.png)
### Installation

Install manually with composer:

```sh
composer require fof/nightmode:"*"
```

### Updating

```sh
composer update fof/nightmode
```

### Integrating with `fof/nightmode` from another extension

Each time the mode is switched from `day` to `night` (and vice versa), a `fofnightmodechange` event is dispatched. An extension can then listen to this event to react to this change, like so:

```js
if (flarum.extensions['fof-nightmode']) {
  document.addEventListener('fofnightmodechange', (event) => {
    if (event.detail == 'day') {
      console.log('day mode');
    } else {
      console.log('night mode');
    }
  });
}
```

### Links

[<img src="https://opencollective.com/fof/donate/button@2x.png?color=blue" height="25" />](https://opencollective.com/fof/donate)

- [Packagist](https://packagist.org/packages/fof/nightmode)
- [GitHub](https://github.com/FriendsOfFlarum/nightmode)
- [ReFlar's Night Mode](https://packagist.org/packages/reflar/nightmode)

An extension by [FriendsOfFlarum](https://github.com/FriendsOfFlarum).
