<?php

/*
 * This file is part of fof/byobu.
 *
 * Copyright (c) FriendsOfFlarum.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FoF\Byobu\Api;

use Flarum\Api\Serializer\ForumSerializer;

class ForumPermissionAttributes
{
    public function __invoke(ForumSerializer $serializer, $model, array $attributes): array
    {
        $actor = $serializer->getActor();
        $users = $actor->can('discussion.startPrivateDiscussionWithUsers');
        $groups = $actor->can('discussion.startPrivateDiscussionWithGroups');

        $attributes['canStartPrivateDiscussion'] = $users || $groups;
        $attributes['canStartPrivateDiscussionWithUsers'] = $users;
        $attributes['canAddMoreThanTwoUserRecipients'] = $actor->can('discussion.addMoreThanTwoUserRecipients');
        $attributes['canStartPrivateDiscussionWithGroups'] = $groups;
        $attributes['canStartPrivateDiscussionWithBlockers'] = $actor->can('discussion.startPrivateDiscussionWithBlockers');

        return $attributes;
    }
}
