<?php

/**
* @package   s9e\TextFormatter
* @copyright Copyright (c) The s9e authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Bundles;

abstract class MediaPack extends \s9e\TextFormatter\Bundle
{
	/**
	* @var ?\s9e\TextFormatter\Parser Singleton instance used by parse()
	*/
	protected static ?\s9e\TextFormatter\Parser $parser;

	/**
	* @var ?\s9e\TextFormatter\Renderer Singleton instance used by render()
	*/
	protected static ?\s9e\TextFormatter\Renderer $renderer;

	/**
	* {@inheritdoc}
	*/
	public static function getJS(): string
	{
		return '(function(){const c=[""],e=[256],f=["","t"],m=["","id"],aa=["","key"],q=["","type"],ba=["","path"],r=["","width"],t={flags:3089},v=["","height"],ca=["","show_id"],da=["","track_id"],ea=["","album_id"],fa=[[/(?:)/,c]],ha=["","entry_id"],ia=["","video_id"],ja=["","short_id"],ka=["","user","id"],la=["","type","id"],ma=["","id","type"],na=["","name","id"],oa=["","episode_id"],pa=["","user","slug"],y=["","playlist_id"],qa=/"id"\\s*:\\s*"(\\w+)"/,ra=["","user","type","id"],sa=["","host","name","id"],ta=["","oid","vid",
"hash"],ua=["","channel","clip_id"],va=["","athlete","highlight"],wa=["","account_id","event_id"],z={b:[],r:!1},B={b:[],r:!0},xa=["","show_id","episode_id","t"],ya=[[/imdb\\.com\\/[\\/\\w]+\\/vi(\\d+)/,m]],za=[[/globalnews\\.ca\\/video\\/(\\d+)/,m]],Aa=[/hudl\\.com\\/video\\/(\\w+)(?![\\w\\/])/,m],Ba=[/flickr\\.com\\/photos\\/[^\\/]+\\/(\\d+)/,m],Ca=[[/(\\w+\\/comments\\/\\w+(?:\\/\\w+\\/\\w+)?)/,m]],Da=[/wsj\\.com\\/video\\/[^\\/]+\\/([-0-9A-F]{36})/,m],Ea=[[/([-\\w]+)\\.castos\\.com\\/player\\/(\\d+)/,["","host","id"]]],Fa=[/hudl\\.com\\/video\\/\\d+\\/(\\d+)\\/([\\da-f]+)/,
va],Ga=[[/247sports\\.com\\/playersport\\/[-\\w]*(\\d+)\\/embed/i,["","player_id"]]],Ha=[[/(?:open|play)\\.spotify\\.com\\/(?:intl-\\w+\\/|user\\/[-.\\w]+\\/)*((?:album|artist|episode|playlist|show|track)(?:[:\\/][-.\\w]+)+)/,m]],Ia=[function(a){return/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],E=[function(a,b){let d={},g;for(g in b.d){let l=b.d[g];var n=!1;if(g in a.d){n=l.b;var k=g,h=a.d[g];C.l=k;for(let p=0;p<n.length&&(h=n[p](h,k),!1!==h);++p);delete C.l;n=h}!1!==n?d[g]=n:"undefined"!==typeof l.y?d[g]=l.y:l.r&&D(a)}Ja(a,
d)}],Ka={b:[function(a){let b=/^(?=\\d)(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?$/.exec(a);return b?3600*(b[1]||0)+60*(b[2]||0)+(+b[3]||0):/^(?:0|[1-9]\\d*)$/.test(a)?a:!1}],r:!1},F={b:Ia,r:!1},Oa=[function(a){{var b=G.urlConfig,d=C;let g=La(a.replace(/^\\s+/,"").replace(/\\s+$/,""));(b=Ma(b,g))?(d&&(g.attrValue=a,d.add("err",b,g)),a=!1):a=Na(g)}return a}],Pa={b:[function(a){return/^[-0-9A-Za-z_]+$/.test(a)?a:!1}],r:!1},Qa={y:360,b:Ia,r:!1},Ra={y:640,b:Ia,r:!1},Sa={b:Oa,r:!1},I={e,d:{id:z},j:1,b:E,f:10,k:t,g:5E3},
Ta={e,d:{id:z,t:z},j:1,b:E,f:10,k:t,g:5E3},Ua={e,d:{id:z,user:z},j:1,b:E,f:10,k:t,g:5E3},Va=\'<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"><xsl:output method="html" encoding="utf-8" indent="no"/><xsl:decimal-format decimal-separator="."/><xsl:param$wMEDIAEMBED_THEME"/>$eABCNEWS"><$t$dabcnews"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//abcnews.go.com/video/embed?id={@id}"$i$b/></$t></$t>$j$eACAST"><$o$dacast"$g"$l$q$kno"$rhttps://embed.acast.com/{@show_id}/{@episode_id}?seek={@t}"$iborder:0;height:188px;max-width:900px;width:100%"/>$j$eANCHOR"><$o$danchor"$g"$l$q$kno"$r//anchor.fm/x/embed/episodes/x-{@id}"$iborder:0;height:102px;max-width:768px;width:100%"/>$j$eAPPLEPODCASTS"><$o$dapplepodcasts" allow="autoplay *;encrypted-media *"$g"$l$q$kno"><$u><$v$s@episode_id"><$m$wsrc">https://embed.podcasts.apple.com/$f@country"/>/podcast/episode/id$f@podcast_id"/>?theme=$f$y/>&amp;i=$f@episode_id"/></$m><$m$w$x>border:0;height:175px;max-width:900px;width:100%</$m></$v><$p><$m$wsrc">https://embed.podcasts.apple.com/$f@country"/>/podcast/episode/id$f@podcast_id"/>?theme=$f$y/></$m><$m$w$x>border:0;height:450px;max-width:900px;width:100%</$m></$p></$u></$o>$j$eAUDIOBOOM"><$o$daudioboom"$g"$l$q$kno"$r//audioboom.com/posts/{@id}/embed/v3"$iborder:0;height:150px;max-width:700px;width:100%"/>$j$eAUDIOMACK"><$o$daudiomack"$g"$l$q$kno"><$u><$v$s@mode=\\\'album\\\'"><$m$wsrc">https://www.audiomack.com/embed/album/<$u><$v$s@id">$f@id"/></$v><$p>$f@artist"/>/$f@title"/></$p></$u></$m><$m$w$x>border:0;height:400px;max-width:900px;width:100%</$m></$v><$p><$m$wsrc">https://www.audiomack.com/embed/song/<$u><$v$s@id">$f@id"/></$v><$p>$f@artist"/>/$f@title"/></$p></$u></$m><$m$w$x>border:0;height:252px;max-width:900px;width:100%</$m></$p></$u></$o>$j$eAUDIUS"><$o$daudius"$g"$l$q$kno"><$m$wsrc">https://audius.co/embed/<$u><$v$s@track_id">track/$f@track_id"/>?flavor=compact</$v><$v$s@album_id">album/$f@album_id"/>?flavor=card</$v><$p>playlist/$f@playlist_id"/>?flavor=card</$p></$u></$m><$m$w$x>border:0;height:<$u><$v$s@track_id">12</$v><$p>48</$p></$u>0px;max-width:<$u><$v$s@track_id">9</$v><$p>4</$p></$u>00px;width:100%</$m></$o>$j$eBANDCAMP"><$t$dbandcamp"$i$c400px"><$t$i$a100%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<$u><$v$s@album_id">album=$f@album_id"/><xsl:if$s@track_num">/t=$f@track_num"/></xsl:if></$v><$p>track=$f@track_id"/></$p></$u><xsl:if$s$MEDIAEMBED_THEME=\\\'dark\\\'">/bgcol=333333/linkcol=0f91ff</xsl:if></$m></$o></$t></$t>$j$eBBCNEWS"><$t$dbbcnews"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//www.bbc.com/news/av-embeds/<$u><$v$sstarts-with(@playlist,\\\'/news/\\\')"><$u><$v$scontains(@playlist,\\\'-\\\')">$fsubstring-after(substring-after(translate(@playlist,\\\'A\\\',\\\'#\\\'),\\\'news/\\\'),\\\'-\\\')"/></$v><$p>$fsubstring-after(translate(@playlist,\\\'A\\\',\\\'/\\\'),\\\'/news/\\\')"/></$p></$u></$v><$v$scontains(@id,\\\'/\\\')">$fsubstring-after(@id,\\\'/\\\')"/></$v><$p>$f@id"/></$p></$u></$m></$o></$t></$t>$j$eBITCHUTE"><$t$dbitchute"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://www.bitchute.com/embed/{@id}/"$i$b/></$t></$t>$j$eBRIGHTCOVE"><$t$dbrightcove"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">https://<$u><$v$s@bckey">link.brightcove.com/services/player/bcpid$f@bcpid"/>?bckey=$f@bckey"/>&amp;bctid=$f@bctid"/>&amp;secureConnections=true&amp;secureHTMLConnections=true&amp;autoStart=false&amp;height=360&amp;width=640</$v><$p>players.brightcove.net/$f@bcpid"/>/default_default/index.html?videoId=$f@bctid"/></$p></$u></$m></$o></$t></$t>$j$eBUNNY"><$t$dbunny"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://$o.mediadelivery.net/embed/{@video_library_id}/{@video_id}?autoplay=false"$i$b/></$t></$t>$j$eCAPTIVATE"><$o$dcaptivate"$g"$l$q$kno"$rhttps://player.captivate.fm/episode/{@id}?t={@t}"$iborder:0;border-radius:6px;height:200px;max-width:900px;width:100%"/>$j$eCASTOS"><$o$dcastos"$g"$l$q$kno"$rhttps://player.castos.com/player/{@id}"$iborder:0;height:150px;max-width:900px;width:100%"/>$j$eCBSNEWS"><$t$dcbsnews"$i$c640px"><$t><$u><$v$scontains(@id,\\\'-\\\')"><$m$w$x>$a56.25%</$m><$o$g"$l$q$kno"$rhttps://www.cbsnews.com/embed/videos/{@id}/"$i$b/></$v><$v$s@pid"><$m$w$x>$a62.1875%;padding-bottom:calc(56.25% + 38px)</$m><object data="//www.cbsnews.com/common/video/cbsnews_player.swf"$iheight:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param$wallowfullscreen" value="true"/><param$wflashvars" value="pType=embed&amp;si=254&amp;pid={@pid}"/></object></$v><$p><$m$w$x>$a62.5%;padding-bottom:calc(56.25% + 40px)</$m><object data="//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf"$iheight:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param$wallowfullscreen" value="true"/><param$wflashvars" value="si=254&amp;contentValue={@id}"/></object></$p></$u></$t></$t>$j$eCLYP"><$o$dclyp"$g"$l$q$kno"$rhttps://clyp.it/{@id}/widget"$iborder:0;height:265px;max-width:900px;width:100%"/>$j$eCNBC"><$t$dcnbc"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://player.cnbc.com/p/gZWlPC/cnbc_global?playertype=synd&amp;byGuid={@id}&amp;size=640_360"$i$b/></$t></$t>$j$eCNN"><$t$dcnn"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//fave.api.cnn.io/v1/fav/?video={@id}&amp;customer=cnn&amp;edition=international&amp;env=prod"$i$b/></$t></$t>$j$eCNNMONEY"><$t$dcnnmoney"$i$c560px"><$t$i$a64.285714%"><$o$g"$l$q$kno"$r//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&amp;width=560&amp;height=360"$i$b/></$t></$t>$j$eCODEPEN"><$o$dcodepen"$g"$l$q$kno"$rhttps://codepen.io/{@user}/embed/{@id}?height=400&amp;default-tab=html,result"$iborder:0;height:400px;width:100%"/>$j$eCOMEDYCENTRAL"><$t$dcomedycentral"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//media.mtvnservices.com/embed/{@id}"$i$b/></$t></$t>$j$eCOUB"><$t$dcoub"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//coub.com/embed/{@id}"$i$b/></$t></$t>$j$eDAILYMOTION"><$t$ddailymotion"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//www.dailymotion.com/embed/video/$f@id"/><xsl:if$s@t">?start=$f@t"/></xsl:if></$m></$o></$t></$t>$j$eDEMOCRACYNOW"><$t$ddemocracynow"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//www.democracynow.org/embed/<$u><$v$scontains(@id,\\\'/headlines\\\')">headlines/$fsubstring-before(@id,\\\'/headlines\\\')"/></$v><$v$sstarts-with(@id,\\\'2\\\')">story/$f@id"/></$v><$v$sstarts-with(@id,\\\'shows/\\\')">show/$fsubstring-after(@id,\\\'/\\\')"/></$v><$p>$f@id"/></$p></$u></$m></$o></$t></$t>$j$eDUMPERT"><$t$ddumpert"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.dumpert.nl/embed/{translate(@id,\\\'/\\\',\\\'_\\\')}"$i$b/></$t></$t>$j$eEIGHTTRACKS"><$t$deighttracks"$i$c400px"><$t$i$a100%"><$o$g"$l$q$kno"$r//8tracks.com/mixes/{@id}/player_v3_universal"$i$b/></$t></$t>$j$eESPN"><$t$despn"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.espn.com/core/video/$o?id={@id}"$i$b/></$t></$t>$j$eFACEBOOK"><$o$dfacebook"$g"$n$x$l$q$z$h$kno"$iborder:0;height:360px;max-width:640px;width:100%"><$m$wsrc">https://s9e.github.io/$o/2/facebook.min.html#<$u><$v$s@user">$f@user"/>/<$u><$v$s@type=\\\'r\\\'or@type=\\\'v\\\'">video</$v><$p>post</$p></$u>s/<$u><$v$s@id">$f@id"/></$v><$p>pfbid$f@pfbid"/></$p></$u></$v><$v$s@id">$f@type"/>$f@id"/></$v><$p>pfbid$f@pfbid"/></$p></$u></$m></$o>$j$eFALSTAD"><$o$dfalstad"$g"$l$q$kno"$iborder:0;height:500px;max-height:90vh;width:100%"><$m$wsrc">https://www.falstad.com/circuit/circuitjs.html?running=false&amp;c<$u><$v$s@cct">ct=$f@cct"/></$v><$p>tz=$f@ctz"/></$p></$u></$m></$o>$j$eFLICKR"><$t$dflickr"$i$c500px"><$t$i$a100%"><$o$g"$l$q$kno"$rhttps://www.flickr.com/photos/_/{@id}/player/"$i$b/></$t></$t>$j$eFOXNEWS"><$t$dfoxnews"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//video.foxnews.com/v/video-embed.html?video_id={@id}"$i$b/></$t></$t>$j$eFUNNYORDIE"><$t$dfunnyordie"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.funnyordie.com/embed/{@id}"$i$b/></$t></$t>$j$eGAMESPOT"><$t$dgamespot"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.gamespot.com/videos/embed/{@id}/"$i$b/></$t></$t>$j$eGETTY"><$t$dgetty"$i$c{@width}px"><$t><$m$w$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$f100*@height div@width"/>%</xsl:if></$m><$o$g"$l$q$kno"$r//embed.gettyimages.com/embed/{@id}?et={@et}&amp;tld=com&amp;sig={@sig}&amp;caption=false&amp;ver=1"$i$b/></$t></$t>$j$eGIFS"><$t$dgifs"$i$c{@width}px"><$t><$m$w$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$f100*@height div@width"/>%</xsl:if></$m><$o$g"$l$q$kno"$r//gifs.com/embed/{@id}"$i$b/></$t></$t>$j$eGIPHY"><$t$dgiphy"$i$c{@width}px"><$t><$m$w$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$f100*@height div@width"/>%</xsl:if></$m><$o$g"$l$q$kno"$i$b><$m$wsrc">//giphy.com/embed/$f@id"/><xsl:if$s@type=\\\'video\\\'">/video</xsl:if></$m></$o></$t></$t>$j$eGIST"><$o$dgist"$g"$n$x$l$q$z$h$k"$rhttps://s9e.github.io/$o/2/gist.min.html#{@id}"$iborder:0;height:180px;width:100%"/>$j$eGLOBALNEWS"><$t$dglobalnews"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//globalnews.ca/video/embed/{@id}/"$i$b/></$t></$t>$j$eGOFUNDME"><$t$dgofundme"$i$c349px"><$t$i$a118.911175%;padding-bottom:calc(59.312321% + 208px)"><$o$g"$l$q$kno"$r//www.gofundme.com/mvc.php?route=widgets/mediawidget&amp;fund={@id}&amp;image=1&amp;coinfo=1"$i$b/></$t></$t>$j$eGOOGLEDRIVE"><$t$dgoogledrive"$i$c640px"><$t$i$a75%"><$o$g"$l$q$kno"$r//drive.google.com/file/d/{@id}/preview"$i$b/></$t></$t>$j$eGOOGLEPLUS"><$o$dgoogleplus"$g"$n$x$l$q$z$h$kno"$iborder:0;height:240px;max-width:450px;width:100%"><$m$wsrc">https://s9e.github.io/$o/2/googleplus.min.html#<$u><$v$s@oid">$f@oid"/></$v><$p>+$f@name"/></$p></$u>/posts/$f@pid"/></$m></$o>$j$eGOOGLESHEETS"><$u><$v$s@type=\\\'chart\\\'"><$t$dgooglesheets"$i$c600px"><$t$i$a62%"><$o$g"$l$q$kno"$rhttps://docs.google.com/spreadsheets/d/{@id}/pubchart?oid={@oid}&amp;format=interactive"$i$b/></$t></$t></$v><$p><$o$dgooglesheets"$g"$l$q$kno"$iborder:0;height:500px;resize:vertical;width:100%"><$m$wsrc">https://docs.google.com/spreadsheets/d/$f@id"/>/p<$u><$v$sstarts-with(@id,\\\'e/\\\')">ubhtml?widget=true&amp;headers=false</$v><$p>review</$p></$u>#gid=$f@gid"/></$m></$o></$p></$u>$j$eHUDL"><$t$dhudl"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//www.hudl.com/embed/<$u><$v$s@id">video/$f@id"/></$v><$p>athlete/$f@athlete"/>/highlights/$f@highlight"/></$p></$u></$m></$o></$t></$t>$j$eHULU"><$t$dhulu"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://secure.hulu.com/embed/{@id}"$i$b/></$t></$t>$j$eIGN"><$t$dign"$i$c468px"><$t$i$a56.196581%"><$o$g"$l$q$kno"$r//widgets.ign.com/video/embed/content.html?url={@id}"$i$b/></$t></$t>$j$eIMDB"><$t$dimdb"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://www.imdb.com/video/embed/vi{@id}/?autoplay=false&amp;width=640"$i$b/></$t></$t>$j$eIMGUR"><$o$dimgur"$g"$n$x$l$q$zlet c=new MessageChannel;c.port1.onmessage=e=&gt;{{let s=this.style,d=e.data.split(\\\' \\\');s.height=d[0]+\\\'px\\\';s.width=d[1]+\\\'px\\\'}};this.contentWindow.postMessage(\\\'s9e:init\\\',\\\'*\\\',[c.port2])"$kno"$iborder:0;height:400px;max-width:100%;width:542px"><$m$wsrc">https://s9e.github.io/$o/2/imgur.min.html#<xsl:if$s@type=\\\'album\\\'">a/</xsl:if>$f@id"/></$m></$o>$j$eINDIEGOGO"><$t$dindiegogo"$i$c222px"><$t$i$a200.45045%"><$o$g"$l$q$kno"$r//www.indiegogo.com/project/{@id}/embedded"$i$b/></$t></$t>$j$eINSTAGRAM"><$o$dinstagram"$g"$n$x$l$q$z$h$kno"$iborder:0;height:542px;max-width:542px;width:100%"><$m$wsrc">https://s9e.github.io/$o/2/instagram.min.html#$f@id"/><xsl:if$s$y>#theme=$f$y/></xsl:if></$m></$o>$j$eINTERNETARCHIVE"><$u><$v$scontains(@id,\\\'playlist=1\\\')"><$o$dinternetarchive"$g"$l$q$kno"$rhttps://archive.org/embed/{@id}&amp;list_height=150"$iborder:0;height:170px;max-width:640px;width:100%"/></$v><$p><$t$dinternetarchive"$i$c{@width}px"><$t><$m$w$x>display:block;overflow:hidden;position:relative;<xsl:if$s@width&gt;0">padding-bottom:$f100*@height div@width"/>%</xsl:if></$m><$o$g"$l$q$kno"$rhttps://archive.org/embed/{@id}"$i$b/></$t></$t></$p></$u>$j$eIZLESENE"><$t$dizlesene"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.izlesene.com/embedplayer/{@id}?autoplay=0"$i$b/></$t></$t>$j$eJSFIDDLE"><$o$djsfiddle"$g"$l$q$kno"$iborder:0;height:400px;width:100%"><$m$wsrc">//jsfiddle.net/$f@id"/>/$f@revision"/>/embedded/<xsl:if$s$MEDIAEMBED_THEME=\\\'light\\\'or$MEDIAEMBED_THEME=\\\'dark\\\'">$f$y/>/</xsl:if></$m></$o>$j$eJWPLATFORM"><$t$djwplatform"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//content.jwplatform.com/players/{@id}.html"$i$b/></$t></$t>$j$eKALTURA"><$t$dkaltura"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">https://cdnapisec.kaltura.com/p/$f@partner_id"/>/sp/<$u><$v$s@sp">$f@sp"/></$v><$p>$f@partner_id"/>00</$p></$u>/embedIframeJs/uiconf_id/$f@uiconf_id"/>/partner_id/$f@partner_id"/>?$oembed=true&amp;entry_id=$f@entry_id"/></$m></$o></$t></$t>$j$eKHL"><$t$dkhl"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//video.khl.ru/$o/feed/start/{@id}?type_id=18&amp;width=560&amp;height=315"$i$b/></$t></$t>$j$eKICKSTARTER"><$t$dkickstarter"><$u><$v$s@video"><$m$w$x>$c640px</$m><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.kickstarter.com/projects/{@id}/widget/video.html"$i$b/></$t></$v><$p><$m$w$x>$c220px</$m><$t$i$a190.909091%"><$o$g"$l$q$kno"$r//www.kickstarter.com/projects/{@id}/widget/card.html"$i$b/></$t></$p></$u></$t>$j$eLIBSYN"><$o$dlibsyn"$g"$l$q$kno"$r//html5-player.libsyn.com/embed/episode/id/{@id}/thumbnail/no"$iborder:0;height:90px;max-width:900px;width:100%"/>$j$eLIVELEAK"><$t$dliveleak"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.liveleak.com/e/{@id}"$i$b/></$t></$t>$j$eLIVESTREAM"><$t$dlivestream"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//<$u><$v$s@clip_id">cdn.livestream.com/embed/$f@channel"/>?layout=4&amp;autoplay=false&amp;clip=$f@clip_id"/></$v><$p>livestream.com/accounts/$f@account_id"/>/events/$f@event_id"/><xsl:if$s@video_id">/videos/$f@video_id"/></xsl:if>/player?autoPlay=false</$p></$u></$m></$o></$t></$t>$j$eMAILRU"><$t$dmailru"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://my.mail.ru/video/embed/{@id}"$i$b/></$t></$t>$j$eMASTODON"><$o$dmastodon"$g"$n$x$l$q$z$h$kno"$iborder:0;height:300px;max-width:550px;width:100%"><$m$wsrc">https://s9e.github.io/$o/2/mastodon.min.html#$f@name"/><xsl:if$s@host and@host!=\\\'mastodon.social\\\'">@$f@host"/></xsl:if>/$f@id"/></$m></$o>$j$eMEDIUM"><$o$dmedium"$g"$n$x$l$q$z$h$kno"$rhttps://s9e.github.io/$o/2/medium.min.html#{@id}"$iborder:0;height:316px;max-width:900px;width:100%"/>$j$eMEGAPHONE"><$o$dmegaphone"$g"$l$q$kno"$iborder:0;height:200px;max-width:900px;width:100%"><$m$wsrc">https://player.megaphone.fm/$f@id"/><xsl:if$s$MEDIAEMBED_THEME=\\\'light\\\'">?light=true</xsl:if></$m></$o>$j$eMETACAFE"><$t$dmetacafe"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.metacafe.com/embed/{@id}/"$i$b/></$t></$t>$j$eMIXCLOUD"><$o$dmixcloud"$g"$l$q$kno"$iborder:0;height:120px;max-width:900px;width:100%"><$m$wsrc">//www.mixcloud.com/widget/$o/?feed=%2F$f@id"/>%2F&amp;light=<xsl:if$s$MEDIAEMBED_THEME!=\\\'dark\\\'">1</xsl:if></$m></$o>$j$eMLB"><$t$dmlb"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://www.mlb.com/video/share/c-{@id}"$i$b/></$t></$t>$j$eMRCTV"><$t$dmrctv"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://www.mrctv.org/embed/{@id}"$i$b/></$t></$t>$j$eMSNBC"><$t$dmsnbc"$i$c640px"><$t><$u><$v$scontains(@id,\\\'_\\\')"><$m$w$x>$a68.75%;padding-bottom:calc(56.25% + 80px)</$m><$o$g"$l$q$kno"$r//player.theplatform.com/p/7wvmTC/MSNBCEmbeddedOffSite?guid={@id}"$i$b/></$v><$p><$m$w$x>$a56.25%</$m><$o$g"$l$q$kno"$rhttps://www.msnbc.com/msnbc/embedded-video/{@id}"$i$b/></$p></$u></$t></$t>$j$eNATGEOCHANNEL"><$t$dnatgeochannel"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//channel.nationalgeographic.com/{@id}/embed/"$i$b/></$t></$t>$j$eNATGEOVIDEO"><$t$dnatgeovideo"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}"$i$b/></$t></$t>$j$eNBCNEWS"><$t$dnbcnews"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.nbcnews.com/widget/video-embed/{@id}"$i$b/></$t></$t>$j$eNHL"><$t$dnhl"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">https://www.nhl.com/video/embed<xsl:if$s@t">/t-$f@t"/></xsl:if><xsl:if$s@c">/c-$f@c"/></xsl:if>?autostart=false</$m></$o></$t></$t>$j$eNPR"><$o$dnpr"$g"$l$q$kno"$r//www.npr.org/player/embed/{@i}/{@m}"$iborder:0;height:228px;max-width:800px;width:100%"/>$j$eNYTIMES"><$t$dnytimes"$i$c585px"><$t$i$a68.376068%"><$o$g"$l$q$kno"$r//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}"$i$b/></$t></$t>$j$eODYSEE"><$t$dodysee"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">https://odysee.com/$/embed/<$u><$v$s@id"><$u><$v$s@name">$f@name"/></$v><$p>-</$p></$u>/$f@id"/></$v><$p>$f@path"/></$p></$u></$m></$o></$t></$t>$j$eON3"><$o$don3"$g"$n$x$l$q$zlet b=this.contentWindow;window.addEventListener(\\\'message\\\',a=&gt;{{a.source===b&amp;&amp;a.data.height&amp;&amp;(this.style.height=+a.data.height+20+\\\'px\\\')}});b.postMessage(\\\'\\\',\\\'*\\\')"$kno"$rhttps://embed.on3.com/db/{@id}/industry-comparison/"$iborder:0;height:476px;max-width:600px;width:100%"/>$j$eORFIUM"><$o$dorfium"$g"$l$q$kno"><$m$wsrc">https://www.orfium.com/embedded/<$u><$v$s@album_id">album/$f@album_id"/></$v><$v$s@playlist_id">playlist/$f@playlist_id"/></$v><$v$s@set_id">live-set/$f@set_id"/></$v><$p>track/$f@track_id"/></$p></$u></$m><$m$w$x>border:0;height:<$u><$v$s@album_id">550</$v><$p>275</$p></$u>px;max-width:900px;width:100%</$m></$o>$j$ePASTEBIN"><$o$dpastebin"$g"$l$q$k"$r//pastebin.com/embed_$o.php?i={@id}"$iborder:0;height:300px;resize:vertical;width:100%"/>$j$ePINTEREST"><$o$dpinterest"$g"$n$x$l$q$z$h$kno"$rhttps://s9e.github.io/$o/2/pinterest.min.html#{@id}"><$m$w$x>border:0;height:360px;max-width:<$u><$v$scontains(@id,\\\'/\\\')">730</$v><$p>345</$p></$u>px;width:100%</$m></$o>$j$ePODBEAN"><$o$dpodbean"$g"$l$q$kno"$rhttps://www.podbean.com/player-v2/?i={@id}"$iborder:0;height:150px;max-width:900px;width:100%"/>$j$ePREZI"><$t$dprezi"$i$c550px"><$t$i$a72.727273%"><$o$g"$l$q$kno"$r//prezi.com/embed/{@id}/"$i$b/></$t></$t>$j$eREDDIT"><$o$dreddit"$g"$n$x$l$q$z$h$kno"$rhttps://s9e.github.io/$o/2/reddit.min.html#{@id}{@path}#theme={$MEDIAEMBED_THEME}"$iborder:0;height:165px;max-width:800px;width:100%"/>$j$eRUMBLE"><$t$drumble"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://rumble.com/embed/{@id}/"$i$b/></$t></$t>$j$eRUTUBE"><$t$drutube"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//rutube.ru/play/embed/{@id}"$i$b/></$t></$t>$j$eSCRIBD"><$o$dscribd"$g"$l$q$kno"$rhttps://www.scribd.com/embeds/{@id}/content?view_mode=scroll&amp;show_recommendations=false"$iborder:0;height:500px;resize:vertical;width:100%"/>$j$eSENDVID"><$t$dsendvid"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//sendvid.com/embed/{@id}"$i$b/></$t></$t>$j$eSLIDESHARE"><$t$dslideshare"$i$c597px"><$t$i$a81.407035%"><$o$g"$l$q$kno"$rhttps://www.slideshare.net/slideshow/embed_code/key/{@key}"$i$b/></$t></$t>$j$eSOUNDCLOUD"><$o$dsoundcloud"$g"$l$q$kno"><$m$wsrc">https://w.soundcloud.com/player/?url=<$u><$v$s@playlist_id">https%3A//api.soundcloud.com/playlists/$f@playlist_id"/>%3Fsecret_token%3D$f@secret_token"/></$v><$v$s@track_id">https%3A//api.soundcloud.com/tracks/$f@track_id"/>%3Fsecret_token%3D$f@secret_token"/></$v><$p><xsl:if$snot(contains(@id,\\\'://\\\'))">https%3A//soundcloud.com/</xsl:if>$f@id"/></$p></$u></$m><$m$w$x>border:0;height:<$u><$v$s@playlist_id or contains(@id,\\\'/sets/\\\')">450</$v><$p>166</$p></$u>px;max-width:900px;width:100%</$m></$o>$j$eSPORCLE"><$o$dsporcle"$g"$n$x$l$q$z$h$kno"$rhttps://s9e.github.io/$o/2/sporcle.min.html#{@id}"$iborder:0;height:535px;max-width:820px;width:100%"/>$j$eSPORTSNET"><$t$dsportsnet"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//players.brightcove.net/1704050871/rkedLxwfab_default/index.html?videoId={@id}"$i$b/></$t></$t>$j$eSPOTIFY"><$o$dspotify" allow="encrypted-media"$g"$l$q$kno"$rhttps://open.spotify.com/embed/{translate(@id,\\\':\\\',\\\'/\\\')}{@path}"><$m$w$x>border:0;border-radius:12px;height:<$u><$v$sstarts-with(@id,\\\'episode\\\')or starts-with(@id,\\\'show\\\')or starts-with(@id,\\\'track\\\')">152</$v><$p>380</$p></$u>px;max-width:900px;width:100%</$m></$o>$j$eSPREAKER"><$o$dspreaker"$g"$l$q$kno"$rhttps://widget.spreaker.com/player?episode_id={@episode_id}&amp;show_id={@show_id}&amp;theme={$MEDIAEMBED_THEME}"><$m$w$x>border:0;height:<$u><$v$s@episode_id">2</$v><$p>4</$p></$u>00px;max-width:900px;width:100%</$m></$o>$j$eSTEAMSTORE"><$o$dsteamstore"$g"$l$q$kno"$r//store.steampowered.com/widget/{@id}"$iborder:0;height:190px;max-width:900px;width:100%"/>$j$eSTRAWPOLL"><$t$dstrawpoll"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$k"$r//www.strawpoll.me/embed_1/{@id}"$i$b/></$t></$t>$j$eSTREAMABLE"><$t$dstreamable"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//streamable.com/e/{@id}"$i$b/></$t></$t>$j$eTEAMCOCO"><$t$dteamcoco"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//teamcoco.com/embed/v/{@id}"$i$b/></$t></$t>$j$eTED"><$t$dted"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//embed.ted.com/$f@id"/><xsl:if$snot(contains(@id,\\\'.html\\\'))">.html</xsl:if></$m></$o></$t></$t>$j$eTELEGRAM"><$o$dtelegram"$g"$n$x$l$q$z$h$kno"$iborder:0;height:96px;max-width:500px;width:100%"><$m$wsrc">https://s9e.github.io/$o/2/telegram.min.html#$f@id"/><xsl:if$s$y>#theme=$f$y/></xsl:if></$m></$o>$j$eTHEATLANTIC"><$t$dtheatlantic"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.theatlantic.com/video/$o/{@id}/"$i$b/></$t></$t>$j$eTHEGUARDIAN"><$t$dtheguardian"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//embed.theguardian.com/embed/video/{@id}"$i$b/></$t></$t>$j$eTHEONION"><$t$dtheonion"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.theonion.com/video_embed/?id={@id}"$i$b/></$t></$t>$j$eTHREADS"><$o$dthreads"$g"$n$x$l$q$z$h$kno"$rhttps://s9e.github.io/$o/2/threads.min.html#{@id}"$iborder:0;height:300px;max-width:550px;width:100%"/>$j$eTIKTOK"><$o$dtiktok"$g"$n$x$l$q$z$h$kno"$rhttps://s9e.github.io/$o/2/tiktok.min.html#{@id}"$iborder:0;height:740px;max-width:325px;width:100%"/>$j$eTMZ"><$t$dtmz"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}"$i$b/></$t></$t>$j$eTRADINGVIEW"><$o$dtradingview"$g"$l$q$kno"$iborder:0;height:400px;width:100%"><$m$wsrc">https://s.tradingview.com/<$u><$v$s@symbol">widgetembed/?interval=D&amp;symbol=$ftranslate(@symbol,\\\'-\\\',\\\':\\\')"/></$v><$p>embed/$f@chart"/></$p></$u></$m></$o>$j$eTRAILERADDICT"><$t$dtraileraddict"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//v.traileraddict.com/{@id}"$i$b/></$t></$t>$j$eTRENDINGVIEWS"><$t$dtrendingviews"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://trendingviews.com/embed/{@id}"$i$b/></$t></$t>$j$eTUMBLR"><$o$dtumblr"$g"$n$x$l$q$z$h$kno"$rhttps://s9e.github.io/$o/2/tumblr.min.html#{@key}/{@id}"$iborder:0;height:300px;max-width:542px;width:100%"/>$j$eTWENTYFOURSEVENSPORTS"><$o$dtwentyfoursevensports"$g"$l$q$zlet w=this.contentWindow;window.addEventListener(\\\'message\\\',e=&gt;{{if(e.source===w&amp;&amp;e.data.height)this.style.height=e.data.height+\\\'px\\\'}});w.postMessage(\\\'\\\',\\\'*\\\')"$kno"$rhttps://247sports.com/playersport/{@player_id}/embed/"$iborder:0;height:152px;max-width:600px;width:100%"/>$j$eTWITCH"><$t$dtwitch"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$zthis.contentWindow.postMessage(\\\'\\\',\\\'*\\\')"$kno"$rhttps://s9e.github.io/$o/2/twitch.min.html#channel={@channel};clip_id={@clip_id};t={@t};video_id={@video_id}"$i$b/></$t></$t>$j$eTWITTER"><$o$dtwitter" allow="autoplay *"$g"$n$x$l$q$z$h$kno"$iborder:0;height:350px;max-width:550px;width:100%"><$m$wsrc">https://s9e.github.io/$o/2/twitter.min.html#$f@id"/><xsl:if$s$y>#theme=$f$y/></xsl:if></$m></$o>$j$eUSTREAM"><$t$dustream"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//www.ustream.tv/embed/<$u><$v$s@vid">recorded/$f@vid"/></$v><$p>$f@cid"/></$p></$u>?html5ui</$m></$o></$t></$t>$j$eVBOX7"><$t$dvbox7"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//vbox7.com/emb/external.php?vid={@id}"$i$b/></$t></$t>$j$eVEOH"><$t$dveoh"$i$c640px"><$t$i$a62.5%;padding-bottom:calc(56.25% + 40px)"><object data="//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&amp;permalinkId=v{@id}&amp;player=videodetailsembedded&amp;videoAutoPlay=0&amp;id=anonymous"$iheight:100%;left:0;position:absolute;width:100%" type="application/x-shockwave-flash" typemustmatch=""><param$wallowfullscreen" value="true"/></object></$t></$t>$j$eVEVO"><$t$dvevo"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://embed.vevo.com/?isrc={@id}"$i$b/></$t></$t>$j$eVIDEODETECTIVE"><$t$dvideodetective"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.videodetective.com/embed/video/?options=false&amp;autostart=false&amp;playlist=none&amp;publishedid={@id}"$i$b/></$t></$t>$j$eVIMEO"><$t$dvimeo"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$i$b><$m$wsrc">//player.vimeo.com/video/$f@id"/><xsl:if$s@h">?h=$f@h"/></xsl:if><xsl:if$s@t">#t=$f@t"/></xsl:if></$m></$o></$t></$t>$j$eVINE"><$t$dvine"$i$c480px"><$t$i$a100%"><$o$g"$l$q$kno"$rhttps://vine.co/v/{@id}/embed/simple?audio=1"$i$b/></$t></$t>$j$eVK"><$t$dvk"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//vk.com/video_ext.php?oid={@oid}&amp;id={@vid}&amp;hash={@hash}&amp;hd=1"$i$b/></$t></$t>$j$eVOCAROO"><$o$dvocaroo"$g"$l$q$kno"$rhttps://vocaroo.com/embed/{@id}"$iborder:0;height:80px;max-width:900px;width:100%"/>$j$eVOX"><$t$dvox"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//player.ooyala.com/$o.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&amp;ec={@id}"$i$b/></$t></$t>$j$eWASHINGTONPOST"><$t$dwashingtonpost"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//www.washingtonpost.com/video/c/embed/{@id}"$i$b/></$t></$t>$j$eWAVEKIT"><$o$dwavekit"$g"$l$q$kno"><$m$wsrc">https://play.wavekit.app/embed/<$u><$v$s@playlist_id">playlist/$f@playlist_id"/></$v><$p>audio/$f@audio_id"/></$p></$u></$m><$m$w$x>border:0;height:<$u><$v$s@playlist_id">40</$v><$p>17</$p></$u>0px;max-width:900px;width:100%</$m></$o>$j$eWISTIA"><$u><$v$s@type=\\\'audio\\\'"><$o$dwistia"$g"$l$q$kno"$rhttps://fast.wistia.net/embed/$o/{@id}"$iborder:0;height:218px;max-width:900px;width:100%"/></$v><$p><$t$dwistia"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://fast.wistia.net/embed/$o/{@id}"$i$b/></$t></$t></$p></$u>$j$eWSHH"><$t$dwshh"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//worldstarhiphop.com/embed/{@id}"$i$b/></$t></$t>$j$eWSJ"><$t$dwsj"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//video-api.wsj.com/api-video/player/$o.html?guid={@id}"$i$b/></$t></$t>$j$eXBOXCLIPS"><$t$dxboxclips"$i$c560px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//gameclips.io/{@user}/{@id}/embed"$i$b/></$t></$t>$j$eXBOXDVR"><$t$dxboxdvr"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//gamerdvr.com/gamer/{@user}/video/{@id}/embed"$i$b/></$t></$t>$j$eXENFORO"><$o$dxenforo"$g"$n$x$l$q$z$h$kno"$iborder:0;height:300px;width:100%"><$m$wsrc">https://s9e.github.io/$o/2/xenforo.min.html#$f@url"/><$u><$v$s@profile_post_id">profile-posts/$f@profile_post_id"/></$v><$v$s@resource_id">resources/$f@resource_id"/></$v><$v$s@xfmg_album_id">media/albums/$f@xfmg_album_id"/></$v><$p>threads/$f@thread_id"/><xsl:if$s@post_id">/post-$f@post_id"/></xsl:if></$p></$u></$m></$o>$j$eYOUKU"><$t$dyouku"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$r//player.youku.com/embed/{@id}"$i$b/></$t></$t>$j$eYOUMAKER"><$t$dyoumaker"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$rhttps://www.youmaker.com/embed/{@id}"$i$b/></$t></$t>$j$eYOUTUBE"><$t$dyoutube"$i$c640px"><$t$i$a56.25%"><$o$g"$l$q$kno"$ibackground:url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover;$b><$m$wsrc">https://www.youtube.com/embed/$f@id"/><$u><$v$s@clip">?clip=$f@clip"/>&amp;clipt=$f@clipt"/></$v><$p><xsl:if$s@list">?list=$f@list"/></xsl:if><xsl:if$s@t"><$u><$v$s@list">&amp;</$v><$p>?</$p></$u>start=$f@t"/></xsl:if></$p></$u></$m></$o></$t></$t>$j$ebr"><br/>$j$ee|i|s"/>$ep"><p><xsl:apply-templates/></p>$j</xsl:stylesheet>\'.replace(/\\$[a-z]/g,
function(a){return{$a:"display:block;overflow:hidden;position:relative;padding-bottom:",$b:\'border:0;height:100%;left:0;position:absolute;width:100%"\',$c:"display:inline-block;width:100%;max-width:",$d:\' data-s9e-mediaembed="\',$e:\'<xsl:template match="\',$f:\'<xsl:value-of select="\',$g:\' allowfullscreen="\',$h:"let c=new MessageChannel;c.port1.onmessage=e=&gt;this.style.height=e.data+\'px\';this.contentWindow.postMessage(\'s9e:init\',\'*\',[c.port2])\\"",$i:\' style="\',$j:"</xsl:template>",$k:\' scrolling="\',
$l:\' loading="\',$m:"xsl:attribute",$n:\' data-s9e-livepreview-ignore-attrs="\',$o:"iframe",$p:"xsl:otherwise",$q:\'lazy"\',$r:\' src="\',$s:\' test="\',$t:"span",$u:"xsl:choose",$v:"xsl:when",$w:\' name="\',$x:\'style"\',$y:\'$MEDIAEMBED_THEME"\',$z:\' onload="\'}[a]});
function La(a){let b=/^(?:([a-z][-+.\\w]*):)?(?:\\/\\/(?:([^:\\/?#]*)(?::([^\\/?#]*)?)?@)?(?:(\\[[a-f\\d:]+\\]|[^:\\/?#]+)(?::(\\d*))?)?(?![^\\/?#]))?([^?#]*)(\\?[^#]*)?(#.*)?$/i.exec(a),d={};"scheme user pass host port path query fragment".split(" ").forEach(function(g,n){d[g]=""<b[n+1]?b[n+1]:""});d.scheme=d.scheme.toLowerCase();d.host=d.host.replace(/[\\u3002\\uff0e\\uff61]/g,".").replace(/\\.+$/g,"");/[^\\x00-\\x7F]/.test(d.host)&&"undefined"!==typeof punycode&&(d.host=punycode.toASCII(d.host));return d}
function Na(a){let b="";""!==a.scheme&&(b+=a.scheme+":");""!==a.host?(b+="//",""!==a.user&&(b+=Wa(decodeURIComponent(a.user)),""!==a.pass&&(b+=":"+Wa(decodeURIComponent(a.pass))),b+="@"),b+=a.host,""!==a.port&&(b+=":"+a.port)):"file"===a.scheme&&(b+="//");let d=a.path+a.query+a.fragment;d=d.replace(/%.?[a-f]/g,function(g){return g.toUpperCase()},d);b+=Xa(d);a.scheme||(b=b.replace(/^([^\\/]*):/,"$1%3A"));return b}
function Xa(a){return a.replace(/[^\\u0020-\\u007E]+/g,encodeURIComponent).replace(/%(?![0-9A-Fa-f]{2})|[^!#-&*-;=?-Z_a-z~]/g,function(b){return"%"+b[0].charCodeAt(0).toString(16).toUpperCase()})}
function Ma(a,b){if(""!==b.scheme&&!a.F.test(b.scheme))return"URL scheme is not allowed";if(""!==b.host){var d;if(d=!/^(?!-)[-a-z0-9]{0,62}[a-z0-9](?:\\.(?!-)[-a-z0-9]{0,62}[a-z0-9])*$/i.test(b.host)){a:if(d=b.host,/^\\d+\\.\\d+\\.\\d+\\.\\d+$/.test(d))for(var g=4,n=d.split(".");0<=--g;){if("0"===n[g][0]||255<n[g]){d=!1;break a}}else d=!1;if(d=!d)d=b.host.replace(/^\\[(.*)\\]$/,"$1",b.host),d=!(/^([\\da-f]{0,4}:){2,7}(?:[\\da-f]{0,4}|\\d+\\.\\d+\\.\\d+\\.\\d+)$/.test(d)&&d)}if(d)return"URL host is invalid";if(a.G&&
a.G.test(b.host)||a.J&&!a.J.test(b.host))return"URL host is not allowed"}else if(/^(?:(?:f|ht)tps?)$/.test(b.scheme))return"Missing host"}function Ya(a){return a.replace(/[<>&"]/g,b=>({"<":"&lt;",">":"&gt;","&":"&amp;",\'"\':"&quot;"})[b])}function Za(a){return a.replace(/[<>&]/g,b=>({"<":"&lt;",">":"&gt;","&":"&amp;"})[b])}function Wa(a){return encodeURIComponent(a).replace(/[!\'()*]/g,b=>"%"+b.charCodeAt(0).toString(16).toUpperCase())}function $a(){this.q={};this.u=[]}
$a.prototype.add=function(a,b,d){d=d||{};"attrName"in d||!this.l||(d.attrName=this.l);"tag"in d||!this.n||(d.tag=this.n);this.q[a]&&this.q[a].forEach(g=>{g(b,d)});this.u.push([a,b,d])};$a.prototype.getLogs=function(){return this.u};$a.prototype.on=function(a,b){this.q[a].push(b)};function ab(a,b){C.add("debug",a,b)}function K(a,b,d,g,n){this.s=+a;this.name=b;this.l=+d;this.n=+g;this.x=+n||0;this.d={};this.z=[];isNaN(a+d+g)&&D(this)}K.prototype.q=!1;
function D(a){a.q||(a.q=!0,a.z.forEach(function(b){D(b)}))}function bb(a,b){cb(a,b)?(a.v=b,b.u=a,a.z.push(b),a.q&&D(b)):cb(b,a)&&(a.u=b,b.v=a)}function cb(a,b){return a.name===b.name&&1===a.s&&2===b.s&&a.l<=a.l}function db(a){let b={};for(let d in a.d)b[d]=a.d[d];return b}function eb(a,b){return a.q||!cb(b,a)||a.u&&a.u!==b||b.v&&b.v!==a?!1:!0}function Ja(a,b){a.d={};for(let d in b)a.d[d]=b[d]}let L,fb,M,N,O,gb,C=new $a,P,Q;
const S={MediaEmbed:{I:function(a,b){b.forEach(d=>{let g=d[0][0];R(3,"MEDIA",d[0][1],g.length,-10).d.url=g})},B:"://",C:/\\bhttps?:\\/\\/[^["\'\\s]+/ig,D:5E4}};let T;
const G={"MediaEmbed.hosts":{"247sports.com":"twentyfoursevensports","8tracks.com":"eighttracks","abcnews.go.com":"abcnews","acast.com":"acast","anchor.fm":"anchor","archive.org":"internetarchive","audioboo.fm":"audioboom","audioboom.com":"audioboom","audiomack.com":"audiomack","audius.co":"audius","bandcamp.com":"bandcamp","bbc.co.uk":"bbcnews","bbc.com":"bbcnews","bitchute.com":"bitchute","captivate.fm":"captivate","castos.com":"castos","cbsnews.com":"cbsnews","cc.com":"comedycentral","channel.nationalgeographic.com":"natgeochannel",
"clyp.it":"clyp","cnbc.com":"cnbc","cnn.com":"cnn","codepen.io":"codepen","comedycentral.com":"comedycentral","coub.com":"coub","dai.ly":"dailymotion","dailymotion.com":"dailymotion","democracynow.org":"democracynow","docs.google.com":"googlesheets","drive.google.com":"googledrive","dumpert.nl":"dumpert","espn.com":"espn","espn.go.com":"espn","facebook.com":"facebook","falstad.com":"falstad","fb.watch":"facebook","flic.kr":"flickr","flickr.com":"flickr","funnyordie.com":"funnyordie","gameclips.io":"xboxclips",
"gamerdvr.com":"xboxdvr","gamespot.com":"gamespot","gettyimages.be":"getty","gettyimages.cn":"getty","gettyimages.co.jp":"getty","gettyimages.co.uk":"getty","gettyimages.com":"getty","gettyimages.com.au":"getty","gettyimages.de":"getty","gettyimages.dk":"getty","gettyimages.es":"getty","gettyimages.fr":"getty","gettyimages.ie":"getty","gettyimages.it":"getty","gettyimages.nl":"getty","gettyimages.pt":"getty","gettyimages.se":"getty","gifs.com":"gifs","giphy.com":"giphy","github.com":"gist","globalnews.ca":"globalnews",
"gofundme.com":"gofundme","gty.im":"getty","hudl.com":"hudl","hulu.com":"hulu","iframe.mediadelivery.net":"bunny","ign.com":"ign","imdb.com":"imdb","imgur.com":"imgur","indiegogo.com":"indiegogo","instagram.com":"instagram","izlesene.com":"izlesene","jsfiddle.net":"jsfiddle","jwplatform.com":"jwplatform","kaltura.com":"kaltura","kickstarter.com":"kickstarter","libsyn.com":"libsyn","link.brightcove.com":"brightcove","link.tospotify.com":"spotify","liveleak.com":"liveleak","livestre.am":"livestream",
"livestream.com":"livestream","mastodon.social":"mastodon","medium.com":"medium","megaphone.fm":"megaphone","megaphone.link":"megaphone","metacafe.com":"metacafe","mixcloud.com":"mixcloud","mlb.com":"mlb","money.cnn.com":"cnnmoney","mrctv.org":"mrctv","msnbc.com":"msnbc","my.mail.ru":"mailru","mydailyfreedom.com":"trendingviews","n.pr":"npr","nbcnews.com":"nbcnews","nhl.com":"nhl","npr.org":"npr","nytimes.com":"nytimes","odysee.com":"odysee","on3.com":"on3","open.spotify.com":"spotify","orfium.com":"orfium",
"pastebin.com":"pastebin","pinterest.com":"pinterest","play.spotify.com":"spotify","play.wavekit.app":"wavekit","players.brightcove.net":"brightcove","plus.google.com":"googleplus","podbean.com":"podbean","podcasts.apple.com":"applepodcasts","prezi.com":"prezi","reddit.com":"reddit","rumble.com":"rumble","rutube.ru":"rutube","scribd.com":"scribd","sendvid.com":"sendvid","slideshare.net":"slideshare","soundcloud.com":"soundcloud","sporcle.com":"sporcle","sportsnet.ca":"sportsnet","spotify.link":"spotify",
"spreaker.com":"spreaker","store.steampowered.com":"steamstore","strawpoll.me":"strawpoll","streamable.com":"streamable","t.me":"telegram","teamcoco.com":"teamcoco","ted.com":"ted","theatlantic.com":"theatlantic","theguardian.com":"theguardian","theonion.com":"theonion","threads.net":"threads","tiktok.com":"tiktok","tmz.com":"tmz","tradingview.com":"tradingview","traileraddict.com":"traileraddict","trendingviews.co":"trendingviews","trendingviews.com":"trendingviews","tumblr.com":"tumblr","twitch.tv":"twitch",
"twitter.com":"twitter","ustream.tv":"ustream","vbox7.com":"vbox7","veoh.com":"veoh","vevo.com":"vevo","video.bunnycdn.com":"bunny","video.foxnews.com":"foxnews","video.khl.ru":"khl","video.nationalgeographic.com":"natgeovideo","videodetective.com":"videodetective","vimeo.com":"vimeo","vine.co":"vine","vk.com":"vk","vkontakte.ru":"vk","voca.ro":"vocaroo","vocaroo.com":"vocaroo","vox.com":"vox","washingtonpost.com":"washingtonpost","wistia.com":"wistia","worldstar.com":"wshh","worldstarhiphop.com":"wshh",
"wsj.com":"wsj","x.com":"twitter","xboxclips.com":"xboxclips","xboxdvr.com":"xboxdvr","youku.com":"youku","youmaker.com":"youmaker","youtu.be":"youtube","youtube-nocookie.com":"youtube","youtube.com":"youtube"},"MediaEmbed.sites":{abcnews:[[[/abcnews\\.go\\.com\\/(?:video\\/embed\\?id=|[^\\/]+\\/video\\/[^\\/]+-)(\\d+)/,m]],[]],acast:[[[/play\\.acast\\.com\\/s\\/([-.\\w]+)\\/([-.\\w]+)(?:\\?seek=(\\d+))?/,xa],[/shows\\.acast\\.com\\/([-.\\w]+)\\/(?:episodes\\/)?([-.\\w]+)(?:\\?seek=(\\d+))?/,xa]],[{a:[[/"showId":"([-0-9a-f]+)/,
ca],[/"id":"([-0-9a-f]+)/,oa]],match:[[/play\\.acast\\.com\\/s\\/[-.\\w]+\\/./,c],[/shows\\.acast\\.com\\/[-.\\w]+\\/./,c]],o:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}"}]],anchor:[[[/anchor.fm\\/(?:[-\\w]+\\/)*episodes\\/(?:[-\\w]+-)(\\w+)(?![-\\w])/,m]],[]],applepodcasts:[[[/podcasts\\.apple\\.com\\/(\\w+)\\/podcast\\/[-\\w]*\\/id(\\d+)(?:\\?i=(\\d+))?/,["","country","podcast_id","episode_id"]]],[]],audioboom:[[[/audioboo(?:\\.f|m\\.co)m\\/(?:boo|post)s\\/(\\d+)/,m]],[]],audiomack:[[[/audiomack\\.com\\/(album|song)\\/([-\\w]+)\\/([-\\w]+)/,
["","mode","artist","title"]],[/audiomack\\.com\\/([-\\w]+)\\/(album|song)\\/([-\\w]+)/,["","artist","mode","title"]]],[]],audius:[[],[{a:[[qa,da]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/(?!album\\/|playlist\\/)([%\\-.\\w]+)/,pa]],o:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}"},{a:[[qa,ea]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/album\\/([%\\-.\\w]+)/,pa]],o:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}"},
{a:[[qa,y]],match:[[/audius\\.co\\/(?!v1\\/)([-.\\w]+)\\/playlist\\/([%\\-.\\w]+)/,pa]],o:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}"}]],bandcamp:[[],[{a:[[/\\/album=(\\d+)/,ea]],p:"User-agent: PHP (not Mozilla)",match:[[/bandcamp\\.com\\/album\\/./,c]]},{a:[[/"album_id":(\\d+)/,ea],[/"track_num":(\\d+)/,["","track_num"]],[/\\/track=(\\d+)/,da]],p:"User-agent: PHP (not Mozilla)",match:[[/bandcamp\\.com\\/track\\/./,c]]}]],bbcnews:[[[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/(?:\\w+-)+(\\d+)/,
m],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/embed\\/(\\w+\\/\\d+)/,m],[/bbc\\.co(?:m|\\.uk)\\/news\\/(?:av|video_and_audio)\\/\\w+\\/(\\d+)/,m],[/bbc\\.co(?:m|\\.uk)\\/news\\/av-embeds\\/(\\d+)/,m]],[]],bitchute:[[[/bitchute\\.com\\/(?:embed|video)\\/([-\\w]+)/,m]],[]],brightcove:[[[/link\\.brightcove\\.com\\/services\\/player\\/bcpid(\\d+).*?bckey=([-,~\\w]+).*?bctid=(\\d+)/,["","bcpid","bckey","bctid"]],[/players\\.brightcove\\.net\\/(\\d+)\\/.*?videoId=(\\d+)/,["","bcpid","bctid"]]],[]],bunny:[[[/\\/(?:embed|play)\\/(\\d+)\\/([-\\w]+)/,
["","video_library_id","video_id"]]],[]],captivate:[[[/\\/\\/player\\.captivate\\.fm\\/episode\\/([-\\w]+)(?:\\?t=(\\d+))?/,["","id","t"]]],[{a:[[/\\/\\/player\\.captivate\\.fm\\/episode\\/([-\\w]+)/,m]],match:[[/\\/\\/(?!player\\.)[-\\w]+\\.captivate\\.fm\\/episode\\/./,c]]}]],castos:[Ea,[{a:Ea,match:[[/castos\\.com\\/(?:podcasts\\/[^\\/]*\\/)?episodes\\/./,c]]}]],cbsnews:[[[/cbsnews\\.com\\/videos?\\/(?!watch\\/)([-\\w]+)/,m],[/cbsnews\\.com\\/video\\/watch\\/\\?id=(\\d+)/,m]],[]],clyp:[[[/clyp\\.it\\/(?!user\\/)(\\w+)/,m]],[]],cnbc:[[[/cnbc\\.com\\/gallery\\/\\?video=(\\d+)/,
m]],[{a:[[/byGuid=(\\d+)/,m]],match:[[/cnbc\\.com\\/video\\/20\\d\\d\\/\\d\\d\\/\\d\\d\\/\\w/,c]]}]],cnn:[[[/cnn.com\\/videos\\/(.*\\.cnn)/,m],[/cnn\\.com\\/video\\/data\\/2\\.0\\/video\\/(.*\\.cnn)/,m]],[]],cnnmoney:[[[/money\\.cnn\\.com\\/video\\/(.*\\.cnnmoney)/,m]],[]],codepen:[[[/codepen\\.io\\/([-\\w]+)\\/(?:details|embed|full|live|pen)\\/(\\w+)/,ka]],[]],comedycentral:[[],[{a:[[/(mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)/,m]],match:[[/c(?:c|omedycentral)\\.com\\/(?:full-episode|video-clip)s\\//,c]]}]],coub:[[[/coub\\.com\\/view\\/(\\w+)/,
m]],[]],dailymotion:[[[/dai\\.ly\\/([a-z0-9]+)/i,m],[/dailymotion\\.com\\/(?:live\\/|swf\\/|user\\/[^#]+#video=|(?:related\\/\\d+\\/)?video\\/)([a-z0-9]+)/i,m],[/start=(\\d+)/,f]],[]],democracynow:[[[/democracynow.org\\/(?:embed\\/)?((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)/,m]],[{a:[[/democracynow\\.org\\/((?:\\w+\\/)?\\d+\\/\\d+\\/\\d+(?:\\/\\w+)?)\' rel=\'canonical/,m]],match:[[/m\\.democracynow\\.org\\/stories\\/\\d/,c]]}]],dumpert:[[[/dumpert\\.nl\\/(?:item|mediabase)\\/(\\d+[\\/_]\\w+)/,m]],[]],eighttracks:[[[/8tracks\\.com\\/[-\\w]+\\/(\\d+)(?=#|$)/,
m]],[{a:[[/eighttracks:\\/\\/mix\\/(\\d+)/,m]],match:[[/8tracks\\.com\\/[-\\w]+\\/\\D/,c]]}]],espn:[[[/video\\/(?:clip(?:\\?id=|\\/_\\/id\\/))?(\\d+)/,m]],[]],facebook:[[[/facebook\\.com\\/.*?(?:fbid=|\\/permalink\\/|\\?v=)(\\d+)/,m],[/facebook\\.com\\/([.\\w]+)\\/([pv])(?:ost|ideo)s?\\/(\\d+)/,ra],[/facebook\\.com\\/video\\/(?=post|video)([pv])/,q],[/facebook\\.com\\/events\\/(\\d+)\\b(?!\\/permalink)/,m],[/facebook\\.com\\/watch\\/\\?([pv])=/,q],[/facebook.com\\/groups\\/[^\\/]*\\/(p)osts\\/(\\d+)/,la],[/facebook\\.com\\/([.\\w]+)\\/posts\\/pfbid(\\w+)/,
["","user","pfbid"]],[/facebook\\.com\\/permalink\\.php\\?story_fbid=(?:(\\d+)|pfbid(\\w+))&id=(\\d+)/,["","id","pfbid","page_id"]],[/facebook\\.com\\/([.\\w]+)\\/(v)ideos\\/[^\\/]+\\/(\\d+)\\//,ra],[/facebook\\.com\\/(r)eel\\/(\\d+)/,la]],[{a:[[/facebook\\.com\\/([.\\w]+)\\/([pv])\\w+\\/(\\d+)(?!\\w)/,ra]],p:"User-agent: PHP (not Mozilla)",match:[[/facebook\\.com\\/[.\\w]+\\/posts\\/pfbid/,c]],o:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2F{@user}%2Fposts%2Fpfbid{@pfbid}"},{a:[[/story_fbid=(\\d+)/,
m]],p:"User-agent: PHP (not Mozilla)",match:[[/facebook\\.com\\/permalink\\.php\\?story_fbid=pfbid(\\w+)&id=(\\d+)/,["","pfbid","page_id"]]],o:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2Fpermalink.php%3Fstory_fbid%3Dpfbid{@pfbid}%26id%3D{@page_id}"},{a:[[/facebook\\.com\\/watch\\/\\?(v)=(\\d+)/,la],[/facebook\\.com\\/([.\\w]+)\\/(v)ideos\\/(\\d+)/,ra]],p:"User-agent: PHP (not Mozilla)",match:[[/fb\\.watch\\/./,c]]}]],falstad:[[[/falstad\\.com\\/circuit\\/circuitjs\\.html\\?c(?:ct=([^&]+)|tz=([-+=\\w]+))/,
["","cct","ctz"]]],[]],flickr:[[Ba,[/flic\\.kr\\/(?!p\\/)[^\\/]+\\/(\\d+)/,m]],[{a:[Ba],match:[[/flic\\.kr\\/p\\/(\\w+)/,["","short"]]],o:"https://www.flickr.com/photo.gne?rb=1&short={@short}"}]],foxnews:[[[/video\\.foxnews\\.com\\/v\\/(\\d+)/,m]],[]],funnyordie:[[[/funnyordie\\.com\\/videos\\/([0-9a-f]+)/,m]],[]],gamespot:[[[/gamespot\\.com.*?\\/(?:events|videos)\\/.*?-(\\d+)\\/(?:[#?].*)?$/,m]],[]],getty:[[],[{a:[[/\\/embed\\/(\\d+)/,m],[/"height":[ "]*(\\d+)/,v],[/"width":[ "]*(\\d+)/,r],[/\\?et=([-=\\w]+)/,["","et"]],[/\\\\u0026sig=([-=\\w]+)/,
["","sig"]]],match:[[/(?:gty\\.im|gettyimages\\.[.\\w]+\\/detail(?=\\/).*?)\\/(\\d+)/,m]],o:"https://embed.gettyimages.com/preview/{@id}"}]],gifs:[[[/gifs\\.com\\/(?:gif\\/)?(\\w+)/,m]],[{a:[[/meta property="og:image:width" content="(\\d+)/,r],[/meta property="og:image:height" content="(\\d+)/,v]],match:fa,o:"https://gifs.com/gif/{@id}"}]],giphy:[[[/giphy\\.com\\/(gif|video|webp)\\w+\\/(?:[-\\w]+-)*(\\w+)/,la],[/giphy\\.com\\/media\\/(\\w+)\\/\\w+\\.(gif|webp)/,ma],[/i\\.giphy\\.com\\/(\\w+)\\.(gif|webp)/,ma]],[{a:[[/"height"\\s*:\\s*(\\d+)/,
v],[/"width"\\s*:\\s*(\\d+)/,r]],p:["Accept: */*","User-agent: PHP"],match:fa,o:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif"}]],gist:[[[/gist\\.github\\.com\\/((?:[-\\w]+\\/)?[\\da-f]+(?:\\/[\\da-f]+)?\\b(?!\\/archive))/,m]],[]],globalnews:[za,[{a:za,match:[[/globalnews\\.ca\\/video\\/rd\\//,c]]}]],gofundme:[[[/gofundme\\.com\\/(\\w+)(?![^#?])/,m]],[]],googledrive:[[[/drive\\.google\\.com\\/.*?(?:file\\/d\\/|id=)([-\\w]+)/,m]],[]],googleplus:[[[/\\/\\/plus\\.google\\.com\\/(?:u\\/\\d+\\/)?(?:\\+([^\\/]+)|(\\d+))\\/posts\\/(\\w+)/,
["","name","oid","pid"]]],[]],googlesheets:[[[/docs\\.google\\.com\\/spreadsheet(?:\\/ccc\\?key=|(?:[^e]\\/)+)((?:e\\/)?[-\\w]+)/,m],[/oid=(\\d+)/,["","oid"]],[/#gid=(\\d+)/,["","gid"]],[/\\/pub(chart)/,q]],[]],hudl:[[[/hudl\\.com\\/athlete\\/(\\d+)\\/highlights\\/([\\da-f]+)/,va],Fa,Aa],[{a:[Fa,Aa],match:[[/hudl\\.com\\/v\\//,c]]}]],hulu:[[],[{a:[[/eid=([-\\w]+)/,m]],match:[[/hulu\\.com\\/watch\\//,c]]}]],ign:[[[/(https?:\\/\\/.*?ign\\.com\\/videos\\/.+)/i,m]],[]],imdb:[[],[{a:ya,match:ya,o:"https://www.imdb.com/video/embed/vi{@id}/"}]],
imgur:[[[/imgur\\.com\\/(a\\/\\w+)/,m],[/i\\.imgur\\.com\\/(\\w{5,7})[lms]?\\./,m],[/imgur\\.com\\/(?!upload\\b)(\\w+)(?![\\w.\\/])/,m]],[{a:[[/data-id="([\\w\\/]+)"/,m]],match:[[/imgur\\.com\\/(?![art]\\/|user\\/)((?:gallery\\/)?\\w+)(?![\\w.])/,ba]],o:"https://api.imgur.com/oembed.xml?url=/{@path}"}]],indiegogo:[[[/indiegogo\\.com\\/projects\\/([-\\w]+)/,m]],[]],instagram:[[[/instagram\\.com\\/(?:p|reel|tv)\\/([-\\w]+)/,m]],[]],internetarchive:[[],[{a:[[/meta property="twitter:player" content="https:\\/\\/archive.org\\/embed\\/([^\\/"]+)/,
m],[/meta property="og:video:width" content="(\\d+)/,r],[/meta property="og:video:height" content="(\\d+)/,v]],match:[[/archive\\.org\\/(?:details|embed)\\//,c]]}]],izlesene:[[[/izlesene\\.com\\/video\\/[-\\w]+\\/(\\d+)/,m]],[]],jsfiddle:[[[/jsfiddle.net\\/(?:(\\w+)\\/)?(?!\\d+\\b|embedded\\b|show\\b)(\\w+)\\b(?:\\/(\\d+)\\b)?/,["","user","id","revision"]]],[]],jwplatform:[[[/jwplatform\\.com\\/\\w+\\/([-\\w]+)/,m]],[]],kaltura:[[[/\\/p(?:artner_id)?\\/(\\d+)\\//,["","partner_id"]],[/\\/sp\\/(\\d+)\\//,["","sp"]],[/\\/uiconf_id\\/(\\d+)\\//,
["","uiconf_id"]],[/\\bentry_id[=\\/](\\w+)/,ha]],[{a:[[/kaltura\\.com\\/p\\/(\\d+)\\/sp\\/(\\d+)\\/\\w*\\/uiconf_id\\/(\\d+)(?:\\/.*?\\bentry_id=(\\w+))?/,["","partner_id","sp","uiconf_id","entry_id"]],[/\\/entry_id\\/(\\w+)/,ha]],match:[[/kaltura\\.com\\/(?:media|tiny)\\/./,c]]}]],khl:[[],[{a:[[/\\/feed\\/start\\/([\\/\\w]+)/,m]],match:[[/video\\.khl\\.ru\\/(?:event|quote)s\\/\\d/,c]]}]],kickstarter:[[[/kickstarter\\.com\\/projects\\/([^\\/]+\\/[^\\/?]+)(?:\\/widget\\/(?:(card)|(video)))?/,["","id","card","video"]]],[]],libsyn:[[],[{a:[[/embed\\/episode\\/id\\/(\\d+)/,
m]],match:[[/(?!\\.mp3)....$/,c]]}]],liveleak:[[[/liveleak\\.com\\/(?:e\\/|view\\?i=)(\\w+)/,m]],[{a:[[/liveleak\\.com\\/e\\/(\\w+)/,m]],match:[[/liveleak\\.com\\/view\\?t=/,c]]}]],livestream:[[[/livestream\\.com\\/accounts\\/(\\d+)\\/events\\/(\\d+)/,wa],[/\\/videos\\/(\\d+)/,ia],[/original\\.livestream\\.com\\/(\\w+)\\/video\\?clipId=([-\\w]+)/,ua]],[{a:[[/accounts\\/(\\d+)\\/events\\/(\\d+)/,wa]],match:[[/livestream\\.com\\/(?!accounts\\/\\d+\\/events\\/\\d)/,c]]},{a:[[/\\/\\/original\\.livestream\\.com\\/(\\w+)\\/video\\/([-\\w]+)/,ua]],match:[[/livestre.am/,
c]]}]],mailru:[[],[{a:[[/"itemId": ?"?(\\d+)/,m]],match:[[/my\\.mail\\.ru\\/\\w+\\/\\w+\\/video\\/\\w+\\/\\d/,c]]}]],mastodon:[[[/\\/\\/([-.\\w]+)\\/(?:web\\/)?(?:@|users\\/)(\\w+)\\/(?:posts\\/|statuses\\/)?(\\d+)/,sa]],[{a:[[/"url":"https:\\/\\/([-.\\w]+)\\/@(\\w+)\\/(\\d+)"/,sa]],match:[[/^(https:\\/\\/[^\\/]+)\\/(?:web\\/)?(?:@\\w+@[-.\\w]+|statuses)\\/(\\d+)/,["","origin","id"]]],o:"{@origin}/api/v1/statuses/{@id}"}]],medium:[[[/medium\\.com\\/(?:s\\/\\w+\\/|@?[-\\w]+\\/)?(?:[%\\w]+-)*([0-9a-f]+)(?![%\\w])/,m]],[]],megaphone:[[[/megaphone\\.fm\\/.*?\\?(?:e|selected)=(\\w+)/,
m],[/(?:dcs|player|traffic)\\.megaphone\\.fm\\/(\\w+)/,m],[/megaphone\\.link\\/(\\w+)/,m]],[]],metacafe:[[[/metacafe\\.com\\/watch\\/(\\d+)/,m]],[]],mixcloud:[[[/mixcloud\\.com\\/(?!categories|tag)([-\\w]+\\/[^\\/&]+)\\//,m]],[]],mlb:[[[/mlb\\.com\\/video\\/(?:[-\\w\\/]+\\/)?(?:c-|v|[-\\w]+-c)(\\d+)/,m]],[]],mrctv:[[],[{a:[[/mrctv\\.org\\/embed\\/(\\d+)/,m]],match:[[/mrctv\\.org\\/videos\\/./,c]]}]],msnbc:[[],[{a:[[/embedded-video\\/(?!undefined)(\\w+)/,m]],match:[[/msnbc\\.com\\/[-\\w]+\\/watch\\//,c],[/on\\.msnbc\\.com\\/./,c]]}]],natgeochannel:[[[/channel\\.nationalgeographic\\.com\\/([-\\/\\w]+\\/videos\\/[-\\w]+)/,
m]],[]],natgeovideo:[[],[{a:[[/guid="([-\\w]+)"/,m]],match:[[/video\\.nationalgeographic\\.com\\/(?:tv|video)\\/\\w/,c]]}]],nbcnews:[[[/nbcnews\\.com\\/(?:widget\\/video-embed\\/|video\\/[-\\w]+-)(\\d+)/,m]],[]],nhl:[[[/nhl\\.com\\/(?:\\w+\\/)?video(?:\\/(?![ct]-)[-\\w]+)?(?:\\/t-(\\d+))?(?:\\/c-(\\d+))?/,["","t","c"]]],[]],npr:[[],[{a:[[/player\\/embed\\/(\\d+)\\/(\\d+)/,["","i","m"]]],p:"Cookie: trackingChoice=false; choiceVersion=1",match:[[/npr\\.org\\/[\\/\\w]+\\/\\d+/,c],[/n\\.pr\\/\\w/,c]]}]],nytimes:[[[/nytimes\\.com\\/video\\/[a-z]+\\/(?:[a-z]+\\/)?(\\d+)/,
m],[/nytimes\\.com\\/video\\/\\d+\\/\\d+\\/\\d+\\/[a-z]+\\/(\\d+)/,m]],[{a:[[/\\/video\\/movies\\/(\\d+)/,m]],match:[[/nytimes\\.com\\/movie(?:s\\/movie)?\\/(\\d+)\\/[-\\w]+\\/trailers/,["","playlist"]]],o:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true"}]],odysee:[[[/odysee\\.com\\/(?:\\$\\/\\w+\\/)?([^:\\/]+)[:\\/](\\w{40})/,na],[/odysee\\.com\\/(@[^:\\/]+:\\w\\/[^:\\/]+:\\w)/,ba]],[{a:[[/"contentUrl".*api\\/\\w+\\/streams\\/\\w+\\/([^\\/]+)\\/(\\w{40})/,na]],match:[[/odysee\\.com\\/@[^\\/:]+:\\w+\\/./,c]]}]],on3:[[[/\\/db\\/(?:[-\\w]*-)?([0-9]+)\\/industry-comparison\\//,
m]],[]],orfium:[[[/album\\/(\\d+)/,ea],[/playlist\\/(\\d+)/,y],[/live-set\\/(\\d+)/,["","set_id"]],[/track\\/(\\d+)/,da]],[]],pastebin:[[[/pastebin\\.com\\/(?!u\\/)(?:\\w+(?:\\.php\\?i=|\\/))?(\\w+)/,m]],[]],pinterest:[[[/pinterest.com\\/pin\\/(\\d+)/,m],[/pinterest.com\\/(?!_\\/|discover\\/|explore\\/|news_hub\\/|pin\\/|search\\/)([-\\w]+\\/[-\\w]+)/,m]],[]],podbean:[[[/podbean\\.com\\/(?:[-\\w]+\\/)*(?:player[-\\w]*\\/|\\w+\\/pb-)([-\\w]+)/,m]],[{a:[[/podbean\\.com\\/player[^\\/]*\\/\\?i=([-\\w]+)/,m]],p:"User-agent: PHP (not Mozilla)",match:[[/podbean\\.com\\/(?:media\\/shar)?e\\/(?!pb-)/,
c]]}]],prezi:[[[/\\/\\/prezi\\.com\\/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)\\/)(\\w+)\\//,m]],[]],reddit:[Ca,[{a:Ca,p:"User-agent: FreeBSD/11.0 Lynx/56",match:[[/reddit\\.com\\/r\\/[^\\/]+\\/s\\/\\w/,c]]}]],rumble:[[[/rumble\\.com\\/embed\\/(\\w+)/,m]],[{a:[[/video"?:"(\\w+)/,m]],match:[[/rumble\\.com\\/(?!embed\\/)./,c]]}]],rutube:[[[/rutube\\.ru\\/(?:play\\/embed\\/|tracks\\/.*?v=|video\\/)(\\w+)/,
m]],[]],scribd:[[[/scribd\\.com\\/(?:mobile\\/)?(?:doc(?:ument)?|presentation)\\/(\\d+)/,m]],[]],sendvid:[[[/sendvid\\.com\\/(\\w+)/,m]],[]],slideshare:[[[/slideshare.net\\/slideshow\\/embed_code\\/key\\/(\\w+)$/,aa]],[{a:[[/embed_code\\/key\\/(\\w+)/,aa],[/data-slideshow-id="(\\d+)"/,m]],match:[[/slideshare\\.net\\/[^\\/]+\\/\\w(?![-\\w]+-\\d{6,}$)/,c]]}]],soundcloud:[[[/https?:\\/\\/(?:api\\.)?soundcloud\\.com\\/(?!pages\\/)([-\\/\\w]+\\/[-\\/\\w]+|^[^\\/]+\\/[^\\/]+$)/i,m],[/api\\.soundcloud\\.com\\/playlists\\/(\\d+)/,y],[/api\\.soundcloud\\.com\\/tracks\\/(\\d+)(?:\\?secret_token=([-\\w]+))?/,
["","track_id","secret_token"]],[/soundcloud\\.com\\/(?!playlists\\/|tracks\\/)[-\\w]+\\/(?:sets\\/)?[-\\w]+\\/(?=s-)([-\\w]+)/,["","secret_token"]]],[{a:[[/soundcloud(?::\\/)?:tracks:(\\d+)/,da]],p:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/(?!playlists\\/\\d|tracks\\/\\d)[-\\w]+\\/[-\\w]/,c]]},{a:[[/soundcloud(?::\\/)?\\/playlists:(\\d+)/,y]],p:"User-agent: PHP (not Mozilla)",match:[[/soundcloud\\.com\\/[-\\w]+\\/sets\\//,c]]}]],sporcle:[[[/sporcle.com\\/framed\\/.*?gid=(\\w+)/,m]],[{a:[[/encodedGameID\\W+(\\w+)/,
m]],match:[[/sporcle\\.com\\/games\\/(?!\\w*category\\/)[-\\w]+\\/[-\\w]/,c]]}]],sportsnet:[[],[{a:[[/bc_videos\\s*:\\s*(\\d+)/,m]],match:fa}]],spotify:[Ha,[{a:Ha,p:"User-agent: PHP (not Mozilla)",match:[[/https?:\\/\\/(?:link\\.tospotify\\.com|spotify\\.link)\\/./,c]]}]],spreaker:[[[/spreaker\\.com\\/episode\\/(\\d+)/,oa]],[{a:[[/episode_id=(\\d+)/,oa],[/show_id=(\\d+)/,ca]],match:[[/spreaker\\.com\\/(?:show|user)\\/./,c]]}]],steamstore:[[[/store.steampowered.com\\/app\\/(\\d+)/,m]],[]],strawpoll:[[[/strawpoll\\.me\\/(\\d+)/,m]],
[]],streamable:[[[/streamable\\.com\\/(?:e\\/)?(\\w+)/,m]],[]],teamcoco:[[[/teamcoco\\.com\\/video\\/(\\d+)/,m]],[{a:[[/embed\\/v\\/(\\d+)/,m]],match:[[/teamcoco\\.com\\/video\\/\\D/,c]]}]],ted:[[[/ted\\.com\\/((?:talk|playlist)s\\/[-\\w]+(?:\\.html)?)(?![-\\w]|\\/transcript)/i,m]],[]],telegram:[[[/\\/\\/t.me\\/(?!addstickers\\/|joinchat\\/)(?:s\\/)?(\\w+\\/\\d+)/,m]],[]],theatlantic:[[[/theatlantic\\.com\\/video\\/index\\/(\\d+)/,m]],[]],theguardian:[[[/theguardian\\.com\\/(\\w+\\/video\\/20(?:0[0-9]|1[0-7])[-\\/\\w]+)/,m]],[]],theonion:[[[/theonion\\.com\\/video\\/[-\\w]+[-,](\\d+)/,
m]],[]],threads:[[[/threads\\.net\\/(?:@[-\\w.]+\\/pos)?t\\/([-\\w]+)/,m]],[]],tiktok:[[[/tiktok\\.com\\/(?:@[.\\w]+\\/video|v|(?:i18n\\/)?share\\/video)\\/(\\d+)/,m]],[{a:[[/tiktok\\.com\\/(?:@[.\\w]+\\/video|v|(?:i18n\\/)?\\/share\\/video)\\/(\\d+)/,m]],match:[[/\\/\\/v[mt]\\.tiktok\\.com\\/(\\w+)/,ja],[/tiktok\\.com\\/t\\/(\\w+)/,ja]],o:"https://www.tiktok.com/t/{@short_id}"}]],tmz:[[[/tmz\\.com\\/videos\\/(\\w+)/,m]],[]],tradingview:[[[/tradingview\\.com\\/(?:chart\\/[^\\/]+|i)\\/(\\w+)/,["","chart"]],[/tradingview\\.com\\/symbols\\/([-:\\w]+)/,
["","symbol"]]],[]],traileraddict:[[],[{a:[[/v\\.traileraddict\\.com\\/(\\d+)/,m]],match:[[/traileraddict\\.com\\/(?!tags\\/)[^\\/]+\\/./,c]]}]],trendingviews:[[[/(?:mydailyfreedom\\.com|trendingviews\\.com?)\\/(?:tv\\/)?(?:embed|videos?)\\/(?:[^\\/]+-)?(\\d+)/,m]],[]],tumblr:[[[/([-\\w]+)\\.tumblr\\.com\\/post\\/(\\d+)/,na],[/(?:at|www)\\.tumblr\\.com\\/([-\\w]+)\\/(\\d+)/,na]],[{a:[[/did=(?:\\\\"|\\\\u0022)([-\\w]+)/,["","did"]],[/embed\\/post\\/t:([-\\w]+)/,aa]],p:"User-agent: curl",match:[[/\\w\\.tumblr\\.com\\/post\\/\\d/,c],[/(?:at|www)\\.tumblr\\.com\\/[-\\w]+\\/\\d+/,
c]],o:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}"}]],twentyfoursevensports:[Ga,[{a:Ga,p:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36",match:[[/247sports\\.com\\/Player\\/[-\\w]*\\d/i,c]]}]],twitch:[[[/twitch\\.tv\\/(?:videos|\\w+\\/v)\\/(\\d+)?/,ia],[/www\\.twitch\\.tv\\/(?!videos\\/)(\\w+)(?:\\/clip\\/([-\\w]+))?/,ua],[/t=((?:(?:\\d+h)?\\d+m)?\\d+s)/,f],[/clips\\.twitch\\.tv\\/(?:(\\w+)\\/)?([-\\w]+)/,ua]],[]],twitter:[[[/(?:twitter|x)\\.com\\/(?:#!\\/|i\\/)?\\w+\\/(?:status(?:es)?|tweet)\\/(\\d+)/,
m]],[]],ustream:[[[/ustream\\.tv\\/recorded\\/(\\d+)/,["","vid"]]],[{a:[[/embed\\/(\\d+)/,["","cid"]]],match:[[/ustream\\.tv\\/(?!explore\\/|platform\\/|recorded\\/|search\\?|upcoming$|user\\/)(?:channel\\/)?[-\\w]+/,c]]}]],vbox7:[[[/vbox7\\.com\\/play:([\\da-f]+)/,m]],[]],veoh:[[[/veoh\\.com\\/(?:m\\/watch\\.php\\?v=|watch\\/)v(\\w+)/,m]],[]],vevo:[[[/vevo\\.com\\/watch\\/(.*?\\/)?([A-Z]+\\d+)/,["","","id"]]],[]],videodetective:[[[/videodetective\\.com\\/\\w+\\/[-\\w]+\\/(?:trailer\\/P0*)?(\\d+)/,m]],[]],vimeo:[[[/vimeo\\.com\\/(?:channels\\/[^\\/]+\\/|video\\/)?(\\d+)(?:\\/(\\w+))?\\b/,
["","id","h"]],[/#t=([\\dhms]+)/,f]],[]],vine:[[[/vine\\.co\\/v\\/([^\\/]+)/,m]],[]],vk:[[[/vk(?:\\.com|ontakte\\.ru)\\/(?:[\\w.]+\\?z=)?video(-?\\d+)_(\\d+).*?hash=([0-9a-f]+)/,ta],[/vk(?:\\.com|ontakte\\.ru)\\/video_ext\\.php\\?oid=(-?\\d+)&id=(\\d+)&hash=([0-9a-f]+)/,ta]],[{a:[[/meta property="og:video" content=".*?oid=(-?\\d+).*?id=(\\d+).*?hash=([0-9a-f]+)/,ta]],p:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36",match:[[/^(?!.*?hash=)/,c]]}]],vocaroo:[[[/voca(?:\\.ro|roo\\.com)\\/(?:i\\/)?(\\w+)/,
m]],[]],vox:[[[/vox.com\\/.*#ooid=([-\\w]+)/,m]],[]],washingtonpost:[[[/washingtonpost\\.com\\/video\\/c\\/\\w+\\/([-0-9a-f]+)/,m],[/washingtonpost\\.com\\/video\\/[-\\/\\w]+\\/([-0-9a-f]+)_video\\.html/,m]],[]],wavekit:[[[/play\\.wavekit\\.app\\/(?:embed|share)\\/audio\\/(\\w+)/,["","audio_id"]],[/play\\.wavekit\\.app\\/(?:embed|share)\\/playlist\\/(\\w+)/,y]],[]],wistia:[[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)(\\w+)/,m]],[{a:[[/"type":"(?:\\w+_)?(audio)/,q]],match:[[/wistia.com\\/(?:(?:embed\\/iframe|medias)\\/|.*wmediaid=)\\w/,
c]],o:"https://fast.wistia.net/embed/iframe/{@id}"}]],wshh:[[[/worldstar(?:hiphop)?\\.com\\/(?:emb|featur)ed\\/(\\d+)/,m]],[{a:[[/(?:v: ?"?|worldstar(?:hiphop)?\\.com\\/embed\\/)(\\d+)/,m]],match:[[/worldstar(?:hiphop)?\\.com\\/(?:\\w+\\/)?video\\.php\\?v=\\w+/,c]]}]],wsj:[[[/wsj\\.com\\/[^#]*#!([-0-9A-F]{36})/,m],Da],[{a:[Da],match:[[/on\\.wsj\\.com\\/\\w/,c]]}]],xboxclips:[[[/(?:gameclips\\.io|xboxclips\\.com)\\/(?!game\\/)([^\\/]+)\\/(?!screenshots\\/)([-0-9a-f]+)/,ka]],[]],xboxdvr:[[[/(?:gamer|xbox)dvr\\.com\\/gamer\\/([^\\/]+)\\/video\\/(\\d+)/,
ka]],[]],xenforo:[[[/^(https:\\/\\/.*?\\/)media\\/albums\\/(?:[-\\w]+\\.)?(\\d+)/,["","url","xfmg_album_id"]],[/^(https:\\/\\/.*?\\/)(?:members\\/[-.\\w]+\\/#profile-post-|profile-posts\\/)(\\d+)/,["","url","profile_post_id"]],[/^(https:\\/\\/.*?\\/)resources\\/(?:[-\\w]+\\.)?(\\d+)/,["","url","resource_id"]],[/^(https:\\/\\/.*?\\/)threads\\/(?:[-\\w]+\\.)?(\\d+)\\/(?:page-\\d+)?#?(?:post-(\\d+))?/,["","url","thread_id","post_id"]],[/^(https:\\/\\/.*?\\/)embed\\.php\\?content=([-\\w]+)/,["","url","content_id"]]],[]],youku:[[[/youku\\.com\\/v(?:_show|ideo)\\/id_(\\w+=*)/,
m]],[]],youmaker:[[[/youmaker\\.com\\/(?:embed|v(?:ideo)?)\\/([-a-z0-9]+)/i,m]],[]],youtube:[[[/youtube\\.com\\/(?:watch.*?v=|(?:embed|live|shorts|v)\\/|attribution_link.*?v%3D)([-\\w]+)/,m],[/youtube-nocookie\\.com\\/embed\\/([-\\w]+)/,m],[/youtu\\.be\\/([-\\w]+)/,m],[/[#&?]t(?:ime_continue)?=(\\d[\\dhms]*)/,f],[/[&?]list=([-\\w]+)/,["","list"]]],[{a:[[/\\/embed\\/([-\\w]+)\\?clip=([-\\w]+)&amp;clipt=([-\\w]+)/,["","id","clip","clipt"]]],match:[[/youtube\\.com\\/clip\\/./,c]]}]]},urlConfig:{F:/^https?$/i}},hb={e:[771],flags:0},
U={ABCNEWS:I,ACAST:{e,d:{episode_id:z,show_id:z,t:z},j:1,b:E,f:10,k:t,g:5E3},ANCHOR:I,APPLEPODCASTS:{e,d:{country:z,episode_id:z,podcast_id:z},j:1,b:E,f:10,k:t,g:5E3},AUDIOBOOM:I,AUDIOMACK:{e,d:{artist:z,mode:z,title:z},j:1,b:E,f:10,k:t,g:5E3},AUDIUS:{e,d:{album_id:z,playlist_id:z,track_id:z},j:1,b:E,f:10,k:t,g:5E3},BANDCAMP:{e,d:{album_id:z,track_id:z,track_num:z},j:1,b:E,f:10,k:t,g:5E3},BBCNEWS:I,BITCHUTE:I,BRIGHTCOVE:{e,d:{bckey:z,bcpid:z,bctid:z},j:1,b:E,f:10,k:t,g:5E3},BUNNY:{e,d:{video_id:z,
video_library_id:z},j:1,b:E,f:10,k:t,g:5E3},CAPTIVATE:Ta,CASTOS:{e,d:{host:z,id:z},j:1,b:E,f:10,k:t,g:5E3},CBSNEWS:I,CLYP:I,CNBC:I,CNN:I,CNNMONEY:I,CODEPEN:Ua,COMEDYCENTRAL:I,COUB:I,DAILYMOTION:Ta,DEMOCRACYNOW:I,DUMPERT:I,EIGHTTRACKS:I,ESPN:I,FACEBOOK:{e,d:{id:z,page_id:z,pfbid:z,type:z,user:z},j:1,b:E,f:10,k:t,g:5E3},FALSTAD:{e,d:{cct:z,ctz:z},j:1,b:E,f:10,k:t,g:5E3},FLICKR:I,FOXNEWS:I,FUNNYORDIE:I,GAMESPOT:I,GETTY:{e,d:{et:B,height:Qa,id:z,sig:B,width:Ra},j:1,b:E,f:10,k:t,g:5E3},GIFS:{e,d:{height:Qa,
id:z,width:Ra},j:1,b:E,f:10,k:t,g:5E3},GIPHY:{e,d:{height:Qa,id:z,type:z,width:Ra},j:1,b:E,f:10,k:t,g:5E3},GIST:I,GLOBALNEWS:I,GOFUNDME:I,GOOGLEDRIVE:I,GOOGLEPLUS:{e,d:{name:{b:[function(a){return decodeURIComponent(""+a)}],r:!1},oid:z,pid:z},j:1,b:E,f:10,k:t,g:5E3},GOOGLESHEETS:{e,d:{gid:z,id:z,oid:z,type:z},j:1,b:E,f:10,k:t,g:5E3},HUDL:{e,d:{athlete:z,highlight:z,id:z},j:1,b:E,f:10,k:t,g:5E3},HULU:I,IGN:I,IMDB:I,IMGUR:I,INDIEGOGO:I,INSTAGRAM:I,INTERNETARCHIVE:{e,d:{height:Qa,id:{b:[function(){return!1}],
r:!1},width:Ra},j:1,b:E,f:10,k:t,g:5E3},IZLESENE:I,JSFIDDLE:{e,d:{id:z,revision:z,user:z},j:1,b:E,f:10,k:t,g:5E3},JWPLATFORM:I,KALTURA:{e,d:{entry_id:B,partner_id:B,sp:z,uiconf_id:B},j:1,b:E,f:10,k:t,g:5E3},KHL:I,KICKSTARTER:{e,d:{card:z,id:z,video:z},j:1,b:E,f:10,k:t,g:5E3},LIBSYN:I,LIVELEAK:I,LIVESTREAM:{e,d:{account_id:z,channel:z,clip_id:z,event_id:z,video_id:z},j:1,b:E,f:10,k:t,g:5E3},MAILRU:I,MASTODON:{e,d:{host:B,id:z,name:z},j:1,b:E,f:10,k:t,g:5E3},MEDIA:{e:[770],d:{},j:0,b:[function(a){return function(b,
d,g){function n(k,h,l){let p=!1;l.forEach(u=>{let w=u[1],x=u[0].exec(h);x&&(p=!0,w.forEach((H,A)=>{""<x[A]&&""<H&&(k[H]=x[A])}))});return p}(function(k,h,l){D(k);if("url"in k.d){var p=k.d.url;a:{for(var u=/^https?:\\/\\/([^\\/]+)/.exec(p.toLowerCase())[1]||"";""<u;){if(h[u]){h=h[u];break a}u=u.replace(/^[^.]*./,"")}h=""}if(l[h]){u={};n(u,p,l[h][0]);l=u;a:{for(w in l){var w=!1;break a}w=!0}if(!w){u=k.l;p=k.v;if(p){var x=k.n;w=p.l;p=p.n}else x=0,w=k.l+k.n,p=0;h=h.toUpperCase();k=k.x;w=R(2,h,w,p,-k||0);
k=R(1,h,u,x,k||0);bb(k,w);Ja(k,l)}}}})(b,d,g)}(a,G["MediaEmbed.hosts"],G["MediaEmbed.sites"],G.cacheDir)}],f:10,k:{flags:513},g:5E3},MEDIUM:I,MEGAPHONE:I,METACAFE:I,MIXCLOUD:I,MLB:I,MRCTV:I,MSNBC:I,NATGEOCHANNEL:I,NATGEOVIDEO:I,NBCNEWS:I,NHL:{e,d:{c:z,t:z},j:1,b:E,f:10,k:t,g:5E3},NPR:{e,d:{i:z,m:z},j:1,b:E,f:10,k:t,g:5E3},NYTIMES:I,ODYSEE:{e,d:{id:z,name:Sa,path:Sa},j:1,b:E,f:10,k:t,g:5E3},ON3:I,ORFIUM:{e,d:{album_id:z,playlist_id:z,set_id:z,track_id:z},j:1,b:E,f:10,k:t,g:5E3},PASTEBIN:I,PINTEREST:I,
PODBEAN:I,PREZI:I,REDDIT:I,RUMBLE:I,RUTUBE:I,SCRIBD:I,SENDVID:I,SLIDESHARE:{e,d:{id:z,key:B},j:1,b:E,f:10,k:t,g:5E3},SOUNDCLOUD:{e,d:{id:z,playlist_id:z,secret_token:z,track_id:z},j:1,b:E,f:10,k:t,g:5E3},SPORCLE:I,SPORTSNET:I,SPOTIFY:I,SPREAKER:{e,d:{episode_id:z,show_id:z},j:1,b:E,f:10,k:t,g:5E3},STEAMSTORE:I,STRAWPOLL:I,STREAMABLE:I,TEAMCOCO:I,TED:I,TELEGRAM:I,THEATLANTIC:I,THEGUARDIAN:I,THEONION:I,THREADS:I,TIKTOK:I,TMZ:I,TRADINGVIEW:{e,d:{chart:z,symbol:z},j:1,b:E,f:10,k:t,g:5E3},TRAILERADDICT:I,
TRENDINGVIEWS:I,TUMBLR:{e,d:{did:B,id:z,key:B,name:B},j:1,b:E,f:10,k:t,g:5E3},TWENTYFOURSEVENSPORTS:{e,d:{player_id:z},j:1,b:E,f:10,k:t,g:5E3},TWITCH:{e,d:{channel:z,clip_id:z,t:z,video_id:z},j:1,b:E,f:10,k:t,g:5E3},TWITTER:I,USTREAM:{e,d:{cid:z,vid:z},j:1,b:E,f:10,k:t,g:5E3},VBOX7:I,VEOH:I,VEVO:I,VIDEODETECTIVE:I,VIMEO:{e,d:{h:z,id:z,t:Ka},j:1,b:E,f:10,k:t,g:5E3},VINE:I,VK:{e,d:{hash:z,oid:z,vid:z},j:1,b:E,f:10,k:t,g:5E3},VOCAROO:I,VOX:I,WASHINGTONPOST:I,WAVEKIT:{e,d:{audio_id:z,playlist_id:z},j:1,
b:E,f:10,k:t,g:5E3},WISTIA:{e,d:{id:z,type:z},j:1,b:E,f:10,k:t,g:5E3},WSHH:I,WSJ:I,XBOXCLIPS:Ua,XBOXDVR:Ua,XENFORO:{e,d:{content_id:Pa,post_id:F,profile_post_id:F,resource_id:F,thread_id:F,url:{b:Oa,r:!0},xfmg_album_id:F},j:1,b:E,f:10,k:t,g:5E3},YOUKU:I,YOUMAKER:I,YOUTUBE:{e,d:{clip:z,clipt:z,id:Pa,list:z,t:Ka},j:1,b:E,f:10,k:t,g:5E3}};let V,ib,W,X,jb=0,Y;
function kb(a){a=a.replace(/\\r\\n?/g,"\\n");a=a.replace(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\uFFFE\\uFFFF]/g,"");var b=C;b.u=[];delete b.l;delete b.n;L={};fb={};N=0;O=null;gb=!1;P=[];Q="";T=0;V=[];ib=!1;W=a;X=W.length;Y=0;M=hb;M.A=!1;++jb;a=jb;for(var d in S)if(!S[d].w)a:{b=d;var g=S[b];if(!(g.B&&0>W.indexOf(g.B))){var n=[];if("undefined"!==typeof g.C&&"undefined"!==typeof g.D){let k=void 0;n=g.C;g=g.D;n.lastIndex=0;let h=[],l=0;for(;++l<=g&&(k=n.exec(W));){let p=k.index,u=[[k[0],p]],w=0;for(;++w<k.length;){let x=
k[w];void 0===x?u.push(["",-1]):(u.push([x,W.indexOf(x,p)]),p+=x.length)}h.push(u)}n=h;if(!n.length)break a}(0,S[b].I)(W,n)}}lb();Z(X,!0);do d=Q,Q=Q.replace(/<([^ />]+)[^>]*><\\/\\1>/g,"");while(Q!==d);Q=Q.replace(/<\\/i><i>/g,"");Q=Q.replace(/[\\x00-\\x08\\x0B-\\x1F\\uFFFE\\uFFFF]/g,"");Q=Q.replace(/[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/g,mb);d=gb?"r":"t";Q="<"+d+">"+Q+"</"+d+">";if(jb!==a)throw"The parser has been reset during execution";1E4<N&&C.add("warn","Fixing cost limit exceeded",void 0);return Q}
function nb(a){let b={},d;for(d in U[a])b[d]=U[a][d];return U[a]=b}function mb(a){return"&#"+((a.charCodeAt(0)<<10)+a.charCodeAt(1)-56613888)+";"}
function ob(a){gb=!0;let b=a.name,d=a.l,g=a.n,n=0;Z(d,!(a.s&1));let k=g?Za(W.substring(d,d+g)):"";if(a.s&1){Q+="<"+b;let h=db(a),l=[];for(let p in h)l.push(p);l.sort((p,u)=>p>u?1:-1);l.forEach(p=>{Q+=" "+p+\'="\'+Ya(h[p].toString()).replace(/\\n/g,"&#10;")+\'"\'});Q=3===a.s?g?Q+(">"+k+"</"+b+">"):Q+"/>":g?Q+("><s>"+k+"</s>"):Q+">"}else g&&(Q+="<e>"+k+"</e>"),Q+="</"+b+">";for(Y=T=d+g;n&&Y<X&&"\\n"===W[Y];)--n,++Y}
function Z(a,b){var d=0;b&&(M.flags&8?d=-1:b=!1);T>=a&&b&&pb();if(Y>T){var g=Math.min(a,Y);Q+=W.substring(T,g);T=g;T>=a&&b&&pb()}let n=a;for(g=0;d&&--n>=T;){let k=W[n];if(" "!==k&&"\\n"!==k&&"\\t"!==k)break;"\\n"===k&&--d;++g}a-=g;a>T&&(d=Za(W.substring(T,a)),Q+=d);b&&pb();g&&(Q+=W.substring(a,a+g));T=a+g}function qb(a){let b=a.l;a=a.n;let d=W.substring(b,b+a);Z(b,!1);Q+="<i>"+Za(d)+"</i>";gb=!0;T=b+a}function pb(){M.A&&(Q+="</p>",M.A=!1)}
function lb(){if(V.length){for(let a in U)L[a]=0,fb[a]=0;do{for(;V.length;)ib||rb(),O=V.pop(),sb();P.forEach(a=>{let b=R(2,a.name,X,0,0);bb(b,a)})}while(V.length)}}
function sb(){M.flags&64&&!eb(O,P[P.length-1])&&!(-1<"br i pb v".indexOf(O.name))&&D(O);var a=O.l,b=O.n;if(T>a&&!O.q){var d;if((d=O.u)&&0<=P.indexOf(d)){bb(R(2,d.name,T,Math.max(0,a+b-T),0),d);return}if("i"===O.name&&(b=a+b-T,0<b)){a=T;R(3,"i",a,Math.min(b,X-a),0);return}D(O)}if(!O.q)if("i"===O.name)qb(O);else if("br"===O.name)M.flags&1024||(Z(O.l,!1),Q+="<br/>");else if("pb"===O.name)Z(O.l,!0);else if("v"===O.name)a=M.flags,M.flags=O.flags,Z(O.l+O.n,!1),M.flags=a;else if(O.s&1){a=O;b=a.name;let g=
U[b];if(fb[b]>=g.g)C.add("err","Tag limit exceeded",{tag:a,tagName:b,tagLimit:g.g}),D(a);else{d=a;let n=U[d.name];C.n=d;for(let k=0;k<n.b.length&&!d.q;++k)n.b[k](d,n);delete C.n;a.q||(L[b]>=g.f?(C.add("err","Nesting limit exceeded",{tag:a,tagName:b,nestingLimit:g.f}),D(a)):(d=U[b].j,M.e[d>>3]&1<<(d&7)?(!(a.flags&1&&3!==a.s)||a.v||V.length&&eb(V[V.length-1],a)||(b=new K(3,b,a.l,a.n),Ja(b,db(a)),b.flags=a.flags,a=b),ob(a),tb(a)):(b={tag:a,tagName:b},0<a.n?C.add("warn","Tag is not allowed in this context",
b):ab("Tag is not allowed in this context",b),D(a))))}}else ub()}
function ub(){var a=O;if(L[a.name]){for(var b=[],d=P.length;0<=--d;){var g=P[d];if(eb(a,g))break;b.push(g);++N}if(0>d)ab("Skipping end tag with no start tag",{tag:a});else{b.forEach(()=>{});var n=0,k=[];b.forEach(h=>{var l=h.name;n&&(h.flags&2?k.push(h):n=!1);l=new K(2,l,a.l,0);l.flags=h.flags;ob(l);vb()});ob(a);vb();if(b.length&&1E4>N){g=T;for(d=V.length;0<=--d&&1E4>++N;){let h=V[d];if(h.l>g||h.s&1)break;let l=b.length;for(;0<=--l&&1E4>++N;)if(eb(h,b[l])){b.splice(l,1);k[l]&&k.splice(l,1);g=Math.max(g,
h.l+h.n);break}}g>T&&qb(new K(3,"i",T,g-T))}k.forEach(h=>{let l=R(h.s,h.name,T,0,h.x);Ja(l,db(h));(h=h.v)&&bb(l,h)})}}}function vb(){let a=P.pop();--L[a.name];M=M.H}function tb(a){let b=a.name,d=a.flags,g=U[b];++fb[b];if(3!==a.s){var n=[];M.e.forEach((h,l)=>{d&512||(h=h&65280|h>>8);n.push(g.e[l]&h)});var k=d|M.flags&32;k&16&&(k&=-33);++L[b];P.push(a);M={H:M};M.e=n;M.flags=k}}
function R(a,b,d,g,n){a=new K(a,b,d,g,n||0);U[b]&&(a.flags=U[b].k.flags);if(!(U[b]||-1<"br i pb v".indexOf(a.name))||0>g||0>d||d+g>X||/[\\uDC00-\\uDFFF]/.test(W.substring(d,d+1)+W.substring(d+g,d+g+1)))D(a);else if(U[b]&&U[b].w)C.add("warn","Tag is disabled",{tag:a,tagName:b}),D(a);else if(ib){b=V.length;for(d=wb(a);0<b&&d>wb(V[b-1]);)V[b]=V[b-1],--b;V[b]=a}else V.push(a);return a}
function rb(){let a={},b=[],d=V.length;for(;0<=--d;){let g=V[d],n=wb(g,d);b.push(n);a[n]=g}b.sort();d=b.length;for(V=[];0<=--d;)V.push(a[b[d]]);ib=!0}function wb(a,b){let d=0<=a.x,g=a.x;d||(g+=1073741824);let n=0<a.n,k;n?k=X-a.n:k={2:0,3:1,1:2}[a.s];return xb(a.l)+ +d+xb(g)+ +n+xb(k)+xb(b||0)}function xb(a){a=a.toString(16);return"        ".substring(a.length)+a}function yb(a){const b=(new DOMParser).parseFromString(a,"text/xml");if(!b)throw"Cannot parse "+a;return b}
function zb(a,b){return Ab.transformToFragment(yb(a),b)}var Ab;Ab=new XSLTProcessor;Ab.importStylesheet(yb(Va));window.s9e||(window.s9e={});
window.s9e.TextFormatter={disablePlugin:function(a){S[a]&&(S[a].w=!0)},disableTag:function(a){U[a]&&(nb(a).w=!0)},enablePlugin:function(a){S[a]&&(S[a].w=!1)},enableTag:function(a){U[a]&&(nb(a).w=!1)},getLogger:function(){return C},parse:kb,preview:function(a,b){function d(h,l){var p=h.childNodes;l=l.childNodes;var u=p.length,w=l.length;let x,H,A=0,J=0;for(;A<u&&A<w;){x=p[A];H=l[A];if(!g(x,H))break;++A}let Bb=Math.min(u-A,w-A);for(;J<Bb;){x=p[u-(J+1)];H=l[w-(J+1)];if(!g(x,H))break;++J}for(u-=J;--u>=
A;)h.removeChild(p[u]),k=h;p=w-J;if(!(A>=p)){w=n.createDocumentFragment();u=A;do H=l[u],k=w.appendChild(H);while(u<--p);J?h.insertBefore(w,h.childNodes[A]):h.appendChild(w)}}function g(h,l){if(h.nodeName!==l.nodeName||h.nodeType!==l.nodeType)return!1;if(h instanceof HTMLElement&&l instanceof HTMLElement){if(!h.isEqualNode(l)){var p=h.attributes;let H=l.attributes;var u=H.length;let A=p.length,J=" "+h.getAttribute("data-s9e-livepreview-ignore-attrs")+" ";for(;0<=--A;){var w=p[A],x=w.namespaceURI;w=
w.name;-1<J.indexOf(" "+w+" ")||l.hasAttributeNS(x,w)||(h.removeAttributeNS(x,w),k=h)}for(A=u;0<=--A;)x=H[A],p=x.namespaceURI,u=x.name,x=x.value,-1<J.indexOf(" "+u+" ")||x===h.getAttributeNS(p,u)||(h.setAttributeNS(p,u,x),k=h);d(h,l)}}else 3!==h.nodeType&&8!==h.nodeType||h.nodeValue===l.nodeValue||(h.nodeValue=l.nodeValue,k=h);return!0}let n=b.ownerDocument;if(!n)throw"Target does not have a ownerDocument";a=zb(kb(a).replace(/<[eis]>[^<]*<\\/[eis]>/g,""),n);let k=b;"undefined"!==typeof window&&"chrome"in
window&&a.querySelectorAll("script").forEach(function(h){let l=document.createElement("script");for(let p of h.attributes)l.setAttribute(p.name,p.value);l.textContent=h.textContent;h.parentNode.replaceChild(l,h)});d(b,a);return k},registeredVars:G,setNestingLimit:function(a,b){U[a]&&(nb(a).f=b)},setParameter:function(a,b){Ab.setParameter(null,a,b)},setTagLimit:function(a,b){U[a]&&(nb(a).g=b)}};})();';
	}

	/**
	* {@inheritdoc}
	*/
	public static function getParser(): \s9e\TextFormatter\Parser
	{
		return unserialize('O:24:"s9e\\TextFormatter\\Parser":4:{s:16:"' . "\0" . '*' . "\0" . 'pluginsConfig";a:1:{s:10:"MediaEmbed";a:4:{s:10:"quickMatch";s:3:"://";s:6:"regexp";s:26:"/\\bhttps?:\\/\\/[^["\'\\s]+/Si";s:7:"tagName";s:5:"MEDIA";s:11:"regexpLimit";i:50000;}}s:14:"registeredVars";a:3:{s:9:"urlConfig";a:1:{s:14:"allowedSchemes";s:12:"/^https?$/Di";}s:16:"MediaEmbed.hosts";a:171:{s:14:"abcnews.go.com";s:7:"abcnews";s:9:"acast.com";s:5:"acast";s:9:"anchor.fm";s:6:"anchor";s:18:"podcasts.apple.com";s:13:"applepodcasts";s:11:"audioboo.fm";s:9:"audioboom";s:13:"audioboom.com";s:9:"audioboom";s:13:"audiomack.com";s:9:"audiomack";s:9:"audius.co";s:6:"audius";s:12:"bandcamp.com";s:8:"bandcamp";s:9:"bbc.co.uk";s:7:"bbcnews";s:7:"bbc.com";s:7:"bbcnews";s:12:"bitchute.com";s:8:"bitchute";s:19:"link.brightcove.com";s:10:"brightcove";s:22:"players.brightcove.net";s:10:"brightcove";s:24:"iframe.mediadelivery.net";s:5:"bunny";s:18:"video.bunnycdn.com";s:5:"bunny";s:12:"captivate.fm";s:9:"captivate";s:10:"castos.com";s:6:"castos";s:11:"cbsnews.com";s:7:"cbsnews";s:7:"clyp.it";s:4:"clyp";s:8:"cnbc.com";s:4:"cnbc";s:7:"cnn.com";s:3:"cnn";s:13:"money.cnn.com";s:8:"cnnmoney";s:10:"codepen.io";s:7:"codepen";s:6:"cc.com";s:13:"comedycentral";s:17:"comedycentral.com";s:13:"comedycentral";s:8:"coub.com";s:4:"coub";s:6:"dai.ly";s:11:"dailymotion";s:15:"dailymotion.com";s:11:"dailymotion";s:16:"democracynow.org";s:12:"democracynow";s:10:"dumpert.nl";s:7:"dumpert";s:11:"8tracks.com";s:11:"eighttracks";s:8:"espn.com";s:4:"espn";s:11:"espn.go.com";s:4:"espn";s:12:"facebook.com";s:8:"facebook";s:8:"fb.watch";s:8:"facebook";s:11:"falstad.com";s:7:"falstad";s:7:"flic.kr";s:6:"flickr";s:10:"flickr.com";s:6:"flickr";s:17:"video.foxnews.com";s:7:"foxnews";s:14:"funnyordie.com";s:10:"funnyordie";s:12:"gamespot.com";s:8:"gamespot";s:14:"gettyimages.be";s:5:"getty";s:14:"gettyimages.cn";s:5:"getty";s:17:"gettyimages.co.jp";s:5:"getty";s:17:"gettyimages.co.uk";s:5:"getty";s:15:"gettyimages.com";s:5:"getty";s:18:"gettyimages.com.au";s:5:"getty";s:14:"gettyimages.de";s:5:"getty";s:14:"gettyimages.dk";s:5:"getty";s:14:"gettyimages.es";s:5:"getty";s:14:"gettyimages.fr";s:5:"getty";s:14:"gettyimages.ie";s:5:"getty";s:14:"gettyimages.it";s:5:"getty";s:14:"gettyimages.nl";s:5:"getty";s:14:"gettyimages.pt";s:5:"getty";s:14:"gettyimages.se";s:5:"getty";s:6:"gty.im";s:5:"getty";s:8:"gifs.com";s:4:"gifs";s:9:"giphy.com";s:5:"giphy";s:10:"github.com";s:4:"gist";s:13:"globalnews.ca";s:10:"globalnews";s:12:"gofundme.com";s:8:"gofundme";s:16:"drive.google.com";s:11:"googledrive";s:15:"plus.google.com";s:10:"googleplus";s:15:"docs.google.com";s:12:"googlesheets";s:8:"hudl.com";s:4:"hudl";s:8:"hulu.com";s:4:"hulu";s:7:"ign.com";s:3:"ign";s:8:"imdb.com";s:4:"imdb";s:9:"imgur.com";s:5:"imgur";s:13:"indiegogo.com";s:9:"indiegogo";s:13:"instagram.com";s:9:"instagram";s:11:"archive.org";s:15:"internetarchive";s:12:"izlesene.com";s:8:"izlesene";s:12:"jsfiddle.net";s:8:"jsfiddle";s:14:"jwplatform.com";s:10:"jwplatform";s:11:"kaltura.com";s:7:"kaltura";s:12:"video.khl.ru";s:3:"khl";s:15:"kickstarter.com";s:11:"kickstarter";s:10:"libsyn.com";s:6:"libsyn";s:12:"liveleak.com";s:8:"liveleak";s:11:"livestre.am";s:10:"livestream";s:14:"livestream.com";s:10:"livestream";s:10:"my.mail.ru";s:6:"mailru";s:15:"mastodon.social";s:8:"mastodon";s:10:"medium.com";s:6:"medium";s:12:"megaphone.fm";s:9:"megaphone";s:14:"megaphone.link";s:9:"megaphone";s:12:"metacafe.com";s:8:"metacafe";s:12:"mixcloud.com";s:8:"mixcloud";s:7:"mlb.com";s:3:"mlb";s:9:"mrctv.org";s:5:"mrctv";s:9:"msnbc.com";s:5:"msnbc";s:30:"channel.nationalgeographic.com";s:13:"natgeochannel";s:28:"video.nationalgeographic.com";s:11:"natgeovideo";s:11:"nbcnews.com";s:7:"nbcnews";s:7:"nhl.com";s:3:"nhl";s:7:"npr.org";s:3:"npr";s:4:"n.pr";s:3:"npr";s:11:"nytimes.com";s:7:"nytimes";s:10:"odysee.com";s:6:"odysee";s:7:"on3.com";s:3:"on3";s:10:"orfium.com";s:6:"orfium";s:12:"pastebin.com";s:8:"pastebin";s:13:"pinterest.com";s:9:"pinterest";s:11:"podbean.com";s:7:"podbean";s:9:"prezi.com";s:5:"prezi";s:10:"reddit.com";s:6:"reddit";s:10:"rumble.com";s:6:"rumble";s:9:"rutube.ru";s:6:"rutube";s:10:"scribd.com";s:6:"scribd";s:11:"sendvid.com";s:7:"sendvid";s:14:"slideshare.net";s:10:"slideshare";s:14:"soundcloud.com";s:10:"soundcloud";s:11:"sporcle.com";s:7:"sporcle";s:12:"sportsnet.ca";s:9:"sportsnet";s:18:"link.tospotify.com";s:7:"spotify";s:16:"open.spotify.com";s:7:"spotify";s:16:"play.spotify.com";s:7:"spotify";s:12:"spotify.link";s:7:"spotify";s:12:"spreaker.com";s:8:"spreaker";s:22:"store.steampowered.com";s:10:"steamstore";s:12:"strawpoll.me";s:9:"strawpoll";s:14:"streamable.com";s:10:"streamable";s:12:"teamcoco.com";s:8:"teamcoco";s:7:"ted.com";s:3:"ted";s:4:"t.me";s:8:"telegram";s:15:"theatlantic.com";s:11:"theatlantic";s:15:"theguardian.com";s:11:"theguardian";s:12:"theonion.com";s:8:"theonion";s:11:"threads.net";s:7:"threads";s:10:"tiktok.com";s:6:"tiktok";s:7:"tmz.com";s:3:"tmz";s:15:"tradingview.com";s:11:"tradingview";s:17:"traileraddict.com";s:13:"traileraddict";s:18:"mydailyfreedom.com";s:13:"trendingviews";s:16:"trendingviews.co";s:13:"trendingviews";s:17:"trendingviews.com";s:13:"trendingviews";s:10:"tumblr.com";s:6:"tumblr";s:13:"247sports.com";s:21:"twentyfoursevensports";s:9:"twitch.tv";s:6:"twitch";s:11:"twitter.com";s:7:"twitter";s:5:"x.com";s:7:"twitter";s:10:"ustream.tv";s:7:"ustream";s:9:"vbox7.com";s:5:"vbox7";s:8:"veoh.com";s:4:"veoh";s:8:"vevo.com";s:4:"vevo";s:18:"videodetective.com";s:14:"videodetective";s:9:"vimeo.com";s:5:"vimeo";s:7:"vine.co";s:4:"vine";s:6:"vk.com";s:2:"vk";s:12:"vkontakte.ru";s:2:"vk";s:7:"voca.ro";s:7:"vocaroo";s:11:"vocaroo.com";s:7:"vocaroo";s:7:"vox.com";s:3:"vox";s:18:"washingtonpost.com";s:14:"washingtonpost";s:16:"play.wavekit.app";s:7:"wavekit";s:10:"wistia.com";s:6:"wistia";s:13:"worldstar.com";s:4:"wshh";s:19:"worldstarhiphop.com";s:4:"wshh";s:7:"wsj.com";s:3:"wsj";s:12:"gameclips.io";s:9:"xboxclips";s:13:"xboxclips.com";s:9:"xboxclips";s:12:"gamerdvr.com";s:7:"xboxdvr";s:11:"xboxdvr.com";s:7:"xboxdvr";s:9:"youku.com";s:5:"youku";s:12:"youmaker.com";s:8:"youmaker";s:20:"youtube-nocookie.com";s:7:"youtube";s:11:"youtube.com";s:7:"youtube";s:8:"youtu.be";s:7:"youtube";}s:16:"MediaEmbed.sites";a:132:{s:7:"abcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:68:"!abcnews\\.go\\.com/(?:video/embed\\?id=|[^/]+/video/[^/]+-)(?\'id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"id";}}}i:1;a:0:{}}s:5:"acast";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:84:"@play\\.acast\\.com/s/(?\'show_id\'[-.\\w]+)/(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"show_id";i:2;s:10:"episode_id";i:3;s:1:"t";}}i:1;a:2:{i:0;s:97:"@shows\\.acast\\.com/(?\'show_id\'[-.\\w]+)/(?:episodes/)?(?\'episode_id\'[-.\\w]+)(?:\\?seek=(?\'t\'\\d+))?@";i:1;R:196;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:34:"@"showId":"(?\'show_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:7:"show_id";}}i:1;a:2:{i:0;s:33:"@"id":"(?\'episode_id\'[-0-9a-f]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"episode_id";}}}s:5:"match";a:2:{i:0;a:2:{i:0;s:30:"@play\\.acast\\.com/s/[-.\\w]+/.@";i:1;a:1:{i:0;s:0:"";}}i:1;a:2:{i:0;s:29:"@shows\\.acast\\.com/[-.\\w]+/.@";i:1;R:219;}}s:3:"url";s:71:"https://feeder.acast.com/api/v1/shows/{@show_id}/episodes/{@episode_id}";}}}s:6:"anchor";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"@anchor.fm/(?:[-\\w]+/)*?episodes/(?:[-\\w]+-)(?\'id\'\\w+)(?![-\\w])@";i:1;R:188;}}i:1;R:191;}s:13:"applepodcasts";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:101:"@podcasts\\.apple\\.com/(?\'country\'\\w+)/podcast/[-\\w]*/id(?\'podcast_id\'\\d+)(?:\\?i=(?\'episode_id\'\\d+))?@";i:1;a:4:{i:0;s:0:"";i:1;s:7:"country";i:2;s:10:"podcast_id";i:3;s:10:"episode_id";}}}i:1;R:191;}s:9:"audioboom";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:49:"!audioboo(?:\\.f|m\\.co)m/(?:boo|post)s/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:9:"audiomack";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:71:"!audiomack\\.com/(?\'mode\'album|song)/(?\'artist\'[-\\w]+)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"mode";i:2;s:6:"artist";i:3;s:5:"title";}}i:1;a:2:{i:0;s:71:"!audiomack\\.com/(?\'artist\'[-\\w]+)/(?\'mode\'album|song)/(?\'title\'[-\\w]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:6:"artist";i:2;s:4:"mode";i:3;s:5:"title";}}}i:1;R:191;}s:6:"audius";a:2:{i:0;R:191;i:1;a:3:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'track_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"track_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:75:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/(?!album/|playlist/)(?\'slug\'[%\\-.\\w]+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"slug";}}}s:3:"url";s:94:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/{@slug}";}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:31:"!"id"\\s*:\\s*"(?\'album_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"album_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:61:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/album/(?\'slug\'[%\\-.\\w]+)@";i:1;R:269;}}s:3:"url";s:100:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/album/{@slug}";}i:2;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!"id"\\s*:\\s*"(?\'playlist_id\'\\w+)"!";i:1;a:2:{i:0;s:0:"";i:1;s:11:"playlist_id";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:64:"@audius\\.co/(?!v1/)(?\'user\'[-.\\w]+)/playlist/(?\'slug\'[%\\-.\\w]+)@";i:1;R:269;}}s:3:"url";s:103:"https://discoveryprovider.audius.co/v1/resolve?app_name=s9e-textformatter&url=/{@user}/playlist/{@slug}";}}}s:8:"bandcamp";a:2:{i:0;R:191;i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!/album=(?\'album_id\'\\d+)!";i:1;R:278;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/album/.!";i:1;R:219;}}}i:1;a:3:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;R:278;}i:1;a:2:{i:0;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:9:"track_num";}}i:2;a:2:{i:0;s:25:"!/track=(?\'track_id\'\\d+)!";i:1;R:263;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:23:"!bandcamp\\.com/track/.!";i:1;R:219;}}}}}s:7:"bbcnews";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:67:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/(?:\\w+-)+(?\'id\'\\d+)@";i:1;R:188;}i:1;a:2:{i:0;s:68:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/embed/(?\'id\'\\w+/\\d+)@";i:1;R:188;}i:2;a:2:{i:0;s:62:"@bbc\\.co(?:m|\\.uk)/news/(?:av|video_and_audio)/\\w+/(?\'id\'\\d+)@";i:1;R:188;}i:3;a:2:{i:0;s:45:"@bbc\\.co(?:m|\\.uk)/news/av-embeds/(?\'id\'\\d+)@";i:1;R:188;}}i:1;R:191;}s:8:"bitchute";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:45:"@bitchute\\.com/(?:embed|video)/(?\'id\'[-\\w]+)@";i:1;R:188;}}i:1;R:191;}s:10:"brightcove";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:107:"@link\\.brightcove\\.com/services/player/bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bckey";i:3;s:5:"bctid";}}i:1;a:2:{i:0;s:65:"@players\\.brightcove\\.net/(?\'bcpid\'\\d+)/.*?videoId=(?\'bctid\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"bcpid";i:2;s:5:"bctid";}}}i:1;R:191;}s:5:"bunny";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"@/(?:embed|play)/(?\'video_library_id\'\\d+)/(?\'video_id\'[-\\w]+)@";i:1;a:3:{i:0;s:0:"";i:1;s:16:"video_library_id";i:2;s:8:"video_id";}}}i:1;R:191;}s:9:"captivate";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:65:"@//player\\.captivate\\.fm/episode/(?\'id\'[-\\w]+)(?:\\?t=(?\'t\'\\d+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:1:"t";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:47:"@//player\\.captivate\\.fm/episode/(?\'id\'[-\\w]+)@";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:47:"@//(?!player\\.)[-\\w]+\\.captivate\\.fm/episode/.@";i:1;R:219;}}}}}s:6:"castos";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:48:"@(?\'host\'[-\\w]+)\\.castos\\.com/player/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"host";i:2;s:2:"id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:375;s:5:"match";a:1:{i:0;a:2:{i:0;s:45:"@castos\\.com/(?:podcasts/[^/]*+/)?episodes/.@";i:1;R:219;}}}}}s:7:"cbsnews";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"#cbsnews\\.com/videos?/(?!watch/)(?\'id\'[-\\w]+)#";i:1;R:188;}i:1;a:2:{i:0;s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";i:1;R:188;}}i:1;R:191;}s:4:"clyp";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"@clyp\\.it/(?!user/)(?\'id\'\\w+)@";i:1;R:188;}}i:1;R:191;}s:4:"cnbc";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!byGuid=(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"!cnbc\\.com/video/20\\d\\d/\\d\\d/\\d\\d/\\w!";i:1;R:219;}}}}}s:3:"cnn";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:1;R:188;}i:1;a:2:{i:0;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";i:1;R:188;}}i:1;R:191;}s:8:"cnnmoney";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";i:1;R:188;}}i:1;R:191;}s:7:"codepen";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:72:"!codepen\\.io/(?\'user\'[-\\w]+)/(?:details|embed|full|live|pen)/(?\'id\'\\w+)!";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";}}}i:1;R:191;}s:13:"comedycentral";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";i:1;R:219;}}}}}s:4:"coub";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:27:"!coub\\.com/view/(?\'id\'\\w+)!";i:1;R:188;}}i:1;R:191;}s:11:"dailymotion";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:27:"!dai\\.ly/(?\'id\'[a-z0-9]+)!i";i:1;R:188;}i:1;a:2:{i:0;s:92:"!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[a-z0-9]+)!i";i:1;R:188;}i:2;a:2:{i:0;s:17:"!start=(?\'t\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:1:"t";}}}i:1;R:191;}s:12:"democracynow";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!m\\.democracynow\\.org/stories/\\d!";i:1;R:219;}}}}}s:7:"dumpert";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!dumpert\\.nl/(?:item|mediabase)/(?\'id\'\\d+[/_]\\w+)!";i:1;R:188;}}i:1;R:191;}s:11:"eighttracks";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:30:"!eighttracks://mix/(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!8tracks\\.com/[-\\w]+/\\D!";i:1;R:219;}}}}}s:4:"espn";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:43:"#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#";i:1;R:188;}}i:1;R:191;}s:8:"facebook";a:2:{i:0;a:10:{i:0;a:2:{i:0;s:55:"@facebook\\.com/.*?(?:fbid=|/permalink/|\\?v=)(?\'id\'\\d+)@";i:1;R:188;}i:1;a:2:{i:0;s:70:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'[pv])(?:ost|ideo)s?/(?\'id\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:4:"type";i:3;s:2:"id";}}i:2;a:2:{i:0;s:49:"@facebook\\.com/video/(?=post|video)(?\'type\'[pv])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"type";}}i:3;a:2:{i:0;s:49:"@facebook\\.com/events/(?\'id\'\\d+)\\b(?!/permalink)@";i:1;R:188;}i:4;a:2:{i:0;s:38:"@facebook\\.com/watch/\\?(?\'type\'[pv])=@";i:1;R:496;}i:5;a:2:{i:0;s:53:"@facebook.com/groups/[^/]*/(?\'type\'p)osts/(?\'id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"type";i:2;s:2:"id";}}i:6;a:2:{i:0;s:56:"@facebook\\.com/(?\'user\'[.\\w]+)/posts/pfbid(?\'pfbid\'\\w+)@";i:1;a:3:{i:0;s:0:"";i:1;s:4:"user";i:2;s:5:"pfbid";}}i:7;a:2:{i:0;s:95:"@facebook\\.com/permalink\\.php\\?story_fbid=(?:(?\'id\'\\d+)|pfbid(?\'pfbid\'\\w+))&id=(?\'page_id\'\\d+)@";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:5:"pfbid";i:3;s:7:"page_id";}}i:8;a:2:{i:0;s:65:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'v)ideos/[^/]+/(?\'id\'\\d+)/@";i:1;R:489;}i:9;a:2:{i:0;s:40:"@facebook\\.com/(?\'type\'r)eel/(?\'id\'\\d+)@";i:1;R:505;}}i:1;a:3:{i:0;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:65:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'[pv])\\w+/(?\'id\'\\d+)(?!\\w)@";i:1;R:489;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:34:"@facebook\\.com/[.\\w]+/posts/pfbid@";i:1;R:219;}}s:3:"url";s:111:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2F{@user}%2Fposts%2Fpfbid{@pfbid}";}i:1;a:4:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:23:"@story_fbid=(?\'id\'\\d+)@";i:1;R:188;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:80:"@facebook\\.com/permalink\\.php\\?story_fbid=pfbid(?\'pfbid\'\\w+)&id=(?\'page_id\'\\d+)@";i:1;a:3:{i:0;s:0:"";i:1;s:5:"pfbid";i:2;s:7:"page_id";}}}s:3:"url";s:140:"https://www.facebook.com/plugins/post.php?href=https%3A%2F%2Fwww.facebook.com%2Fpermalink.php%3Fstory_fbid%3Dpfbid{@pfbid}%26id%3D{@page_id}";}i:2;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:45:"@facebook\\.com/watch/\\?(?\'type\'v)=(?\'id\'\\d+)@";i:1;R:505;}i:1;a:2:{i:0;s:58:"@facebook\\.com/(?\'user\'[.\\w]+)/(?\'type\'v)ideos/(?\'id\'\\d+)@";i:1;R:489;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"@fb\\.watch/.@";i:1;R:219;}}}}}s:7:"falstad";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:81:"!falstad\\.com/circuit/circuitjs\\.html\\?c(?:ct=(?\'cct\'[^&]+)|tz=(?\'ctz\'[-+=\\w]+))!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"cct";i:2;s:3:"ctz";}}}i:1;R:191;}s:6:"flickr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:37:"@flickr\\.com/photos/[^/]+/(?\'id\'\\d+)@";i:1;R:188;}i:1;a:2:{i:0;s:33:"@flic\\.kr/(?!p/)[^/]+/(?\'id\'\\d+)@";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;R:569;}s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"@flic\\.kr/p/(?\'short\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:5:"short";}}}s:3:"url";s:52:"https://www.flickr.com/photo.gne?rb=1&short={@short}";}}}s:7:"foxnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:10:"funnyordie";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";i:1;R:188;}}i:1;R:191;}s:8:"gamespot";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";i:1;R:188;}}i:1;R:191;}s:5:"getty";a:2:{i:0;R:191;i:1;a:1:{i:0;a:3:{s:7:"extract";a:5:{i:0;a:2:{i:0;s:19:"!/embed/(?\'id\'\\d+)!";i:1;R:188;}i:1;a:2:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"height";}}i:2;a:2:{i:0;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"width";}}i:3;a:2:{i:0;s:21:"!\\?et=(?\'et\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:2:"et";}}i:4;a:2:{i:0;s:28:"!\\\\u0026sig=(?\'sig\'[-=\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"sig";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:59:"!(?:gty\\.im|gettyimages\\.[.\\w]+/detail(?=/).*?)/(?\'id\'\\d+)!";i:1;R:188;}}s:3:"url";s:43:"https://embed.gettyimages.com/preview/{@id}";}}}s:4:"gifs";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!gifs\\.com/(?:gif/)?(?\'id\'\\w+)!";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:55:"!meta property="og:image:width" content="(?\'width\'\\d+)!";i:1;R:608;}i:1;a:2:{i:0;s:57:"!meta property="og:image:height" content="(?\'height\'\\d+)!";i:1;R:603;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:2:"//";i:1;R:219;}}s:3:"url";s:26:"https://gifs.com/gif/{@id}";}}}s:5:"giphy";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:62:"!giphy\\.com/(?\'type\'gif|video|webp)\\w+/(?:[-\\w]+-)*(?\'id\'\\w+)!";i:1;R:505;}i:1;a:2:{i:0;s:52:"!giphy\\.com/media/(?\'id\'\\w+)/\\w+\\.(?\'type\'gif|webp)!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"type";}}i:2;a:2:{i:0;s:45:"!i\\.giphy\\.com/(?\'id\'\\w+)\\.(?\'type\'gif|webp)!";i:1;R:646;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!"height"\\s*:\\s*(?\'height\'\\d+)!";i:1;R:603;}i:1;a:2:{i:0;s:29:"!"width"\\s*:\\s*(?\'width\'\\d+)!";i:1;R:608;}}s:6:"header";a:2:{i:0;s:11:"Accept: */*";i:1;s:15:"User-agent: PHP";}s:5:"match";R:636;s:3:"url";s:83:"https://giphy.com/services/oembed?url=https://media.giphy.com/media/{@id}/giphy.gif";}}}s:4:"gist";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:75:"@gist\\.github\\.com/(?\'id\'(?:[-\\w]+/)?[\\da-f]+(?:/[\\da-f]+)?\\b(?!/archive))@";i:1;R:188;}}i:1;R:191;}s:10:"globalnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";R:668;s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"!globalnews\\.ca/video/rd/!";i:1;R:219;}}}}}s:8:"gofundme";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";i:1;R:188;}}i:1;R:191;}s:11:"googledrive";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:52:"!drive\\.google\\.com/.*?(?:file/d/|id=)(?\'id\'[-\\w]+)!";i:1;R:188;}}i:1;R:191;}s:10:"googleplus";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:83:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";i:1;a:4:{i:0;s:0:"";i:1;s:4:"name";i:2;s:3:"oid";i:3;s:3:"pid";}}}i:1;R:191;}s:12:"googlesheets";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:76:"@docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|(?:[^e]/)+)(?\'id\'(?:e/)?[-\\w]+)@";i:1;R:188;}i:1;a:2:{i:0;s:17:"@oid=(?\'oid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"oid";}}i:2;a:2:{i:0;s:18:"@#gid=(?\'gid\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:3:"gid";}}i:3;a:2:{i:0;s:20:"@/pub(?\'type\'chart)@";i:1;R:496;}}i:1;R:191;}s:4:"hudl";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"athlete";i:2;s:9:"highlight";}}i:1;a:2:{i:0;s:60:"!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!";i:1;R:713;}i:2;a:2:{i:0;s:37:"@hudl\\.com/video/(?\'id\'\\w+)(?![\\w/])@";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;R:717;i:1;R:719;}s:5:"match";a:1:{i:0;a:2:{i:0;s:14:"!hudl\\.com/v/!";i:1;R:219;}}}}}s:4:"hulu";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!eid=(?\'id\'[-\\w]+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:18:"!hulu\\.com/watch/!";i:1;R:219;}}}}}s:3:"ign";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:40:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!i";i:1;R:188;}}i:1;R:191;}s:4:"imdb";a:2:{i:0;R:191;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:32:"!imdb\\.com/[/\\w]+?/vi(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";R:743;s:3:"url";s:41:"https://www.imdb.com/video/embed/vi{@id}/";}}}s:5:"imgur";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:25:"@imgur\\.com/(?\'id\'a/\\w+)@";i:1;R:188;}i:1;a:2:{i:0;s:38:"@i\\.imgur\\.com/(?\'id\'\\w{5,7})[lms]?\\.@";i:1;R:188;}i:2;a:2:{i:0;s:45:"@imgur\\.com/(?!upload\\b)(?\'id\'\\w+)(?![\\w./])@";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"@data-id="(?\'id\'[\\w/]+)"@";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:63:"@imgur\\.com/(?![art]/|user/)(?\'path\'(?:gallery/)?\\w+)(?![\\w.])@";i:1;a:2:{i:0;s:0:"";i:1;s:4:"path";}}}s:3:"url";s:45:"https://api.imgur.com/oembed.xml?url=/{@path}";}}}s:9:"indiegogo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";i:1;R:188;}}i:1;R:191;}s:9:"instagram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!instagram\\.com/(?:p|reel|tv)/(?\'id\'[-\\w]+)!";i:1;R:188;}}i:1;R:191;}s:15:"internetarchive";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:3:{i:0;a:2:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;R:188;}i:1;a:2:{i:0;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:1;R:608;}i:2;a:2:{i:0;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";i:1;R:603;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:33:"!archive\\.org/(?:details|embed)/!";i:1;R:219;}}}}}s:8:"izlesene";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:8:"jsfiddle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:96:"@jsfiddle.net/(?:(?\'user\'\\w+)/)?(?!\\d+\\b|embedded\\b|show\\b)(?\'id\'\\w+)\\b(?:/(?\'revision\'\\d+)\\b)?@";i:1;a:4:{i:0;s:0:"";i:1;s:4:"user";i:2;s:2:"id";i:3;s:8:"revision";}}}i:1;R:191;}s:10:"jwplatform";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!";i:1;R:188;}}i:1;R:191;}s:7:"kaltura";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:38:"@/p(?:artner_id)?/(?\'partner_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:10:"partner_id";}}i:1;a:2:{i:0;s:17:"@/sp/(?\'sp\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:2:"sp";}}i:2;a:2:{i:0;s:31:"@/uiconf_id/(?\'uiconf_id\'\\d+)/@";i:1;a:2:{i:0;s:0:"";i:1;s:9:"uiconf_id";}}i:3;a:2:{i:0;s:32:"@\\bentry_id[=/](?\'entry_id\'\\w+)@";i:1;a:2:{i:0;s:0:"";i:1;s:8:"entry_id";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:117:"@kaltura\\.com/p/(?\'partner_id\'\\d+)/sp/(?\'sp\'\\d+)/\\w*/uiconf_id/(?\'uiconf_id\'\\d+)(?:/.*?\\bentry_id=(?\'entry_id\'\\w+))?@";i:1;a:5:{i:0;s:0:"";i:1;s:10:"partner_id";i:2;s:2:"sp";i:3;s:9:"uiconf_id";i:4;s:8:"entry_id";}}i:1;a:2:{i:0;s:28:"@/entry_id/(?\'entry_id\'\\w+)@";i:1;R:824;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:31:"@kaltura\\.com/(?:media|tiny)/.@";i:1;R:219;}}}}}s:3:"khl";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:27:"!/feed/start/(?\'id\'[/\\w]+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";i:1;R:219;}}}}}s:11:"kickstarter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"card";i:3;s:5:"video";}}}i:1;R:191;}s:6:"libsyn";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!embed/episode/id/(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:16:"@(?!\\.mp3)....$@";i:1;R:219;}}}}}s:8:"liveleak";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!liveleak\\.com/(?:e/|view\\?i=)(?\'id\'\\w+)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"!liveleak\\.com/e/(?\'id\'\\w+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!liveleak\\.com/view\\?t=!";i:1;R:219;}}}}}s:10:"livestream";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:10:"account_id";i:2;s:8:"event_id";}}i:1;a:2:{i:0;s:26:"!/videos/(?\'video_id\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"video_id";}}i:2;a:2:{i:0;s:76:"!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:7:"channel";i:2;s:7:"clip_id";}}}i:1;a:2:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;R:886;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@livestream\\.com/(?!accounts/\\d+/events/\\d)@";i:1;R:219;}}}i:1;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:70:"!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!";i:1;R:897;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:13:"!livestre.am!";i:1;R:219;}}}}}s:6:"mailru";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:25:"!"itemId": ?"?(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";i:1;R:219;}}}}}s:8:"mastodon";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:86:"#//(?\'host\'[-.\\w]+)/(?:web/)?(?:@|users/)(?\'name\'\\w+)/(?:posts/|statuses/)?(?\'id\'\\d+)#";i:1;a:4:{i:0;s:0:"";i:1;s:4:"host";i:2;s:4:"name";i:3;s:2:"id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:59:"#"url":"https://(?\'host\'[-.\\w]+)/@(?\'name\'\\w+)/(?\'id\'\\d+)"#";i:1;R:929;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:73:"#^(?\'origin\'https://[^/]+)/(?:web/)?(?:@\\w+@[-.\\w]+|statuses)/(?\'id\'\\d+)#";i:1;a:3:{i:0;s:0:"";i:1;s:6:"origin";i:2;s:2:"id";}}}s:3:"url";s:31:"{@origin}/api/v1/statuses/{@id}";}}}s:6:"medium";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:72:"#medium\\.com/(?:s/\\w+/|@?[-\\w]+/)?(?:[%\\w]+-)*(?\'id\'[0-9a-f]+)(?![%\\w])#";i:1;R:188;}}i:1;R:191;}s:9:"megaphone";a:2:{i:0;a:3:{i:0;a:2:{i:0;s:46:"@megaphone\\.fm/.*?\\?(?:e|selected)=(?\'id\'\\w+)@";i:1;R:188;}i:1;a:2:{i:0;s:50:"@(?:dcs|player|traffic)\\.megaphone\\.fm/(?\'id\'\\w+)@";i:1;R:188;}i:2;a:2:{i:0;s:28:"@megaphone\\.link/(?\'id\'\\w+)@";i:1;R:188;}}i:1;R:191;}s:8:"metacafe";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:8:"mixcloud";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";i:1;R:188;}}i:1;R:191;}s:3:"mlb";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:57:"#mlb\\.com/video/(?:[-\\w/]+/)?(?:c-|v|[-\\w]+-c)(?\'id\'\\d+)#";i:1;R:188;}}i:1;R:191;}s:5:"mrctv";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:29:"!mrctv\\.org/embed/(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"!mrctv\\.org/videos/.!";i:1;R:219;}}}}}s:5:"msnbc";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:40:"@embedded-video/(?!undefined)(?\'id\'\\w+)@";i:1;R:188;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;R:219;}i:1;a:2:{i:0;s:18:"@on\\.msnbc\\.com/.@";i:1;R:219;}}}}}s:13:"natgeochannel";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";i:1;R:188;}}i:1;R:191;}s:11:"natgeovideo";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:22:"@guid="(?\'id\'[-\\w]+)"@";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";i:1;R:219;}}}}}s:7:"nbcnews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:3:"nhl";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:80:"#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#";i:1;a:3:{i:0;s:0:"";i:1;s:1:"t";i:2;s:1:"c";}}}i:1;R:191;}s:3:"npr";a:2:{i:0;R:191;i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:1:"i";i:2;s:1:"m";}}}s:6:"header";s:45:"Cookie: trackingChoice=false; choiceVersion=1";s:5:"match";a:2:{i:0;a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;R:219;}i:1;a:2:{i:0;s:10:"!n\\.pr/\\w!";i:1;R:219;}}}}}s:7:"nytimes";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:1;R:188;}i:1;a:2:{i:0;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:26:"!/video/movies/(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:65:"!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!";i:1;a:2:{i:0;s:0:"";i:1;s:8:"playlist";}}}s:3:"url";s:73:"http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true";}}}s:6:"odysee";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:58:"#odysee\\.com/(?:\\$/\\w+/)?(?\'name\'[^:/]+)[:/](?\'id\'\\w{40})#";i:1;a:3:{i:0;s:0:"";i:1;s:4:"name";i:2;s:2:"id";}}i:1;a:2:{i:0;s:43:"#odysee\\.com/(?\'path\'@[^:/]+:\\w/[^:/]+:\\w)#";i:1;R:763;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:64:"#"contentUrl".*api/\\w+/streams/\\w+/(?\'name\'[^/]+)/(?\'id\'\\w{40})#";i:1;R:1054;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:27:"#odysee\\.com/@[^/:]+:\\w+/.#";i:1;R:219;}}}}}s:3:"on3";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:52:"!/db/(?:[-\\w]*-)?(?\'id\'[0-9]+)/industry-comparison/!";i:1;R:188;}}i:1;R:191;}s:6:"orfium";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:24:"@album/(?\'album_id\'\\d+)@";i:1;R:278;}i:1;a:2:{i:0;s:30:"@playlist/(?\'playlist_id\'\\d+)@";i:1;R:289;}i:2;a:2:{i:0;s:25:"@live-set/(?\'set_id\'\\d+)@";i:1;a:2:{i:0;s:0:"";i:1;s:6:"set_id";}}i:3;a:2:{i:0;s:24:"@track/(?\'track_id\'\\d+)@";i:1;R:263;}}i:1;R:191;}s:8:"pastebin";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@";i:1;R:188;}}i:1;R:191;}s:9:"pinterest";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:30:"@pinterest.com/pin/(?\'id\'\\d+)@";i:1;R:188;}i:1;a:2:{i:0;s:84:"@pinterest.com/(?!_/|discover/|explore/|news_hub/|pin/|search/)(?\'id\'[-\\w]+/[-\\w]+)@";i:1;R:188;}}i:1;R:191;}s:7:"podbean";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:65:"!podbean\\.com/(?:[-\\w]+/)*(?:player[-\\w]*/|\\w+/pb-)(?\'id\'[-\\w]+)!";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:44:"!podbean\\.com/player[^/]*/\\?i=(?\'id\'[-\\w]+)!";i:1;R:188;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:39:"@podbean\\.com/(?:media/shar)?e/(?!pb-)@";i:1;R:219;}}}}}s:5:"prezi";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";i:1;R:188;}}i:1;R:191;}s:6:"reddit";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"!(?\'id\'\\w+/comments/\\w+(?:/\\w+/\\w+)?)!";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1113;s:6:"header";s:32:"User-agent: FreeBSD/11.0 Lynx/56";s:5:"match";a:1:{i:0;a:2:{i:0;s:26:"!reddit\\.com/r/[^/]+/s/\\w!";i:1;R:219;}}}}}s:6:"rumble";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:30:"!rumble\\.com/embed/(?\'id\'\\w+)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:21:"!video"?:"(?\'id\'\\w+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:25:"#rumble\\.com/(?!embed/).#";i:1;R:219;}}}}}s:6:"rutube";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:58:"!rutube\\.ru/(?:play/embed/|tracks/.*?v=|video/)(?\'id\'\\w+)!";i:1;R:188;}}i:1;R:191;}s:6:"scribd";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:67:"!scribd\\.com/(?:mobile/)?(?:doc(?:ument)?|presentation)/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:7:"sendvid";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!sendvid\\.com/(?\'id\'\\w+)!";i:1;R:188;}}i:1;R:191;}s:10:"slideshare";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:54:"!slideshare.net/slideshow/embed_code/key/(?\'key\'\\w+)$!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"key";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:28:"!embed_code/key/(?\'key\'\\w+)!";i:1;R:1150;}i:1;a:2:{i:0;s:32:"!data-slideshow-id="(?\'id\'\\d+)"!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:44:"@slideshare\\.net/[^/]+/\\w(?![-\\w]+-\\d{6,}$)@";i:1;R:219;}}}}}s:10:"soundcloud";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:84:"@https?://(?:api\\.)?soundcloud\\.com/(?!pages/)(?\'id\'[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@i";i:1;R:188;}i:1;a:2:{i:0;s:52:"@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@";i:1;R:289;}i:2;a:2:{i:0;s:89:"@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:1;a:3:{i:0;s:0:"";i:1;s:8:"track_id";i:2;s:12:"secret_token";}}i:3;a:2:{i:0;s:93:"@soundcloud\\.com/(?!playlists/|tracks/)[-\\w]+/(?:sets/)?[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";i:1;a:2:{i:0;s:0:"";i:1;s:12:"secret_token";}}}i:1;a:2:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:43:"@soundcloud(?::/)?:tracks:(?\'track_id\'\\d+)@";i:1;R:263;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:56:"@soundcloud\\.com/(?!playlists/\\d|tracks/\\d)[-\\w]+/[-\\w]@";i:1;R:219;}}}i:1;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:49:"@soundcloud(?::/)?/playlists:(?\'playlist_id\'\\d+)@";i:1;R:289;}}s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:30:"@soundcloud\\.com/[-\\w]+/sets/@";i:1;R:219;}}}}}s:7:"sporcle";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:38:"#sporcle.com/framed/.*?gid=(?\'id\'\\w+)#";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"#encodedGameID\\W+(?\'id\'\\w+)#";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:49:"#sporcle\\.com/games/(?!\\w*category/)[-\\w]+/[-\\w]#";i:1;R:219;}}}}}s:9:"sportsnet";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:28:"@bc_videos\\s*:\\s*(?\'id\'\\d+)@";i:1;R:188;}}s:5:"match";R:636;}}}s:7:"spotify";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:125:"!(?:open|play)\\.spotify\\.com/(?:intl-\\w+/|user/[-.\\w]+/)*(?\'id\'(?:album|artist|episode|playlist|show|track)(?:[:/][-.\\w]+)+)!";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1216;s:6:"header";s:29:"User-agent: PHP (not Mozilla)";s:5:"match";a:1:{i:0;a:2:{i:0;s:51:"!https?://(?:link\\.tospotify\\.com|spotify\\.link)/.!";i:1;R:219;}}}}}s:8:"spreaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!spreaker\\.com/episode/(?\'episode_id\'\\d+)!";i:1;R:213;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:31:"!episode_id=(?\'episode_id\'\\d+)!";i:1;R:213;}i:1;a:2:{i:0;s:25:"!show_id=(?\'show_id\'\\d+)!";i:1;R:208;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:31:"!spreaker\\.com/(?:show|user)/.!";i:1;R:219;}}}}}s:10:"steamstore";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:39:"!store.steampowered.com/app/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:9:"strawpoll";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:10:"streamable";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:35:"!streamable\\.com/(?:e/)?(?\'id\'\\w+)!";i:1;R:188;}}i:1;R:191;}s:8:"teamcoco";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:20:"!embed/v/(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:24:"!teamcoco\\.com/video/\\D!";i:1;R:219;}}}}}s:3:"ted";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:76:"#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i";i:1;R:188;}}i:1;R:191;}s:8:"telegram";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:56:"@//t.me/(?!addstickers/|joinchat/)(?:s/)?(?\'id\'\\w+/\\d+)@";i:1;R:188;}}i:1;R:191;}s:11:"theatlantic";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:11:"theguardian";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!theguardian\\.com/(?\'id\'\\w+/video/20(?:0[0-9]|1[0-7])[-/\\w]+)!";i:1;R:188;}}i:1;R:191;}s:8:"theonion";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:7:"threads";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:47:"!threads\\.net/(?:@[-\\w.]+/pos)?t/(?\'id\'[-\\w]+)!";i:1;R:188;}}i:1;R:191;}s:6:"tiktok";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:66:"#tiktok\\.com/(?:@[.\\w]+/video|v|(?:i18n/)?share/video)/(?\'id\'\\d+)#";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:67:"#tiktok\\.com/(?:@[.\\w]+/video|v|(?:i18n/)?/share/video)/(?\'id\'\\d+)#";i:1;R:188;}}s:5:"match";a:2:{i:0;a:2:{i:0;s:39:"#//v[mt]\\.tiktok\\.com/(?\'short_id\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"short_id";}}i:1;a:2:{i:0;s:32:"#tiktok\\.com/t/(?\'short_id\'\\w+)#";i:1;R:1299;}}s:3:"url";s:36:"https://www.tiktok.com/t/{@short_id}";}}}s:3:"tmz";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";i:1;R:188;}}i:1;R:191;}s:11:"tradingview";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:50:"!tradingview\\.com/(?:chart/[^/]+|i)/(?\'chart\'\\w+)!";i:1;a:2:{i:0;s:0:"";i:1;s:5:"chart";}}i:1;a:2:{i:0;s:45:"!tradingview\\.com/symbols/(?\'symbol\'[-:\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:6:"symbol";}}}i:1;R:191;}s:13:"traileraddict";a:2:{i:0;R:191;i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";i:1;R:219;}}}}}s:13:"trendingviews";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:93:"!(?:mydailyfreedom\\.com|trendingviews\\.com?)/(?:tv/)?(?:embed|videos?)/(?:[^/]+-)?(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:6:"tumblr";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";i:1;R:1054;}i:1;a:2:{i:0;s:52:"!(?:at|www)\\.tumblr\\.com/(?\'name\'[-\\w]+)/(?\'id\'\\d+)!";i:1;R:1054;}}i:1;a:1:{i:0;a:4:{s:7:"extract";a:2:{i:0;a:2:{i:0;s:35:"!did=(?:\\\\"|\\\\u0022)(?\'did\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"did";}}i:1;a:2:{i:0;s:29:"!embed/post/t:(?\'key\'[-\\w]+)!";i:1;R:1150;}}s:6:"header";s:16:"User-agent: curl";s:5:"match";a:2:{i:0;a:2:{i:0;s:25:"!\\w\\.tumblr\\.com/post/\\d!";i:1;R:219;}i:1;a:2:{i:0;s:36:"!(?:at|www)\\.tumblr\\.com/[-\\w]+/\\d+!";i:1;R:219;}}s:3:"url";s:75:"https://www.tumblr.com/oembed/1.0?url=https://{@name}.tumblr.com/post/{@id}";}}}s:21:"twentyfoursevensports";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:60:"!247sports\\.com/playersport/[-\\w]*?(?\'player_id\'\\d+)/embed!i";i:1;a:2:{i:0;s:0:"";i:1;s:9:"player_id";}}}i:1;a:1:{i:0;a:3:{s:7:"extract";R:1358;s:6:"header";s:113:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:34:"!247sports\\.com/Player/[-\\w]*?\\d!i";i:1;R:219;}}}}}s:6:"twitch";a:2:{i:0;a:4:{i:0;a:2:{i:0;s:47:"#twitch\\.tv/(?:videos|\\w+/v)/(?\'video_id\'\\d+)?#";i:1;R:892;}i:1;a:2:{i:0;s:73:"#www\\.twitch\\.tv/(?!videos/)(?\'channel\'\\w+)(?:/clip/(?\'clip_id\'[-\\w]+))?#";i:1;R:897;}i:2;a:2:{i:0;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";i:1;R:448;}i:3;a:2:{i:0;s:59:"#clips\\.twitch\\.tv/(?:(?\'channel\'\\w+)/)?(?\'clip_id\'[-\\w]+)#";i:1;R:897;}}i:1;R:191;}s:7:"twitter";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:70:"@(?:twitter|x)\\.com/(?:#!/|i/)?\\w+/(?:status(?:es)?|tweet)/(?\'id\'\\d+)@";i:1;R:188;}}i:1;R:191;}s:7:"ustream";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"vid";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:19:"!embed/(?\'cid\'\\d+)!";i:1;a:2:{i:0;s:0:"";i:1;s:3:"cid";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";i:1;R:219;}}}}}s:5:"vbox7";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";i:1;R:188;}}i:1;R:191;}s:4:"veoh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:50:"!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!";i:1;R:188;}}i:1;R:191;}s:4:"vevo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!vevo\\.com/watch/(.*?/)?(?\'id\'[A-Z]+\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:0:"";i:2;s:2:"id";}}}i:1;R:191;}s:14:"videodetective";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:59:"!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!";i:1;R:188;}}i:1;R:191;}s:5:"vimeo";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:67:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)(?:/(?\'h\'\\w+))?\\b!";i:1;a:3:{i:0;s:0:"";i:1;s:2:"id";i:2;s:1:"h";}}i:1;a:2:{i:0;s:19:"!#t=(?\'t\'[\\dhms]+)!";i:1;R:448;}}i:1;R:191;}s:4:"vine";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";i:1;R:188;}}i:1;R:191;}s:2:"vk";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:97:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)!";i:1;a:4:{i:0;s:0:"";i:1;s:3:"oid";i:2;s:3:"vid";i:3;s:4:"hash";}}i:1;a:2:{i:0;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";i:1;R:1440;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:99:"#meta property="og:video" content=".*?oid=(?\'oid\'-?\\d+).*?id=(?\'vid\'\\d+).*?hash=(?\'hash\'[0-9a-f]+)#";i:1;R:1440;}}s:6:"header";s:113:"User-agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36";s:5:"match";a:1:{i:0;a:2:{i:0;s:15:"#^(?!.*?hash=)#";i:1;R:219;}}}}}s:7:"vocaroo";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:41:"!voca(?:\\.ro|roo\\.com)/(?:i/)?(?\'id\'\\w+)!";i:1;R:188;}}i:1;R:191;}s:3:"vox";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";i:1;R:188;}}i:1;R:191;}s:14:"washingtonpost";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:51:"#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#";i:1;R:188;}i:1;a:2:{i:0;s:65:"#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#";i:1;R:188;}}i:1;R:191;}s:7:"wavekit";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:59:"#play\\.wavekit\\.app/(?:embed|share)/audio/(?\'audio_id\'\\w+)#";i:1;a:2:{i:0;s:0:"";i:1;s:8:"audio_id";}}i:1;a:2:{i:0;s:65:"#play\\.wavekit\\.app/(?:embed|share)/playlist/(?\'playlist_id\'\\w+)#";i:1;R:289;}}i:1;R:191;}s:6:"wistia";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:63:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)(?\'id\'\\w+)!";i:1;R:188;}}i:1;a:1:{i:0;a:3:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:33:"!"type":"(?:\\w+_)?(?\'type\'audio)!";i:1;R:496;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:55:"!wistia.com/(?:(?:embed/iframe|medias)/|.*wmediaid=)\\w!";i:1;R:219;}}s:3:"url";s:42:"https://fast.wistia.net/embed/iframe/{@id}";}}}s:4:"wshh";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!worldstar(?:hiphop)?\\.com/(?:emb|featur)ed/(?\'id\'\\d+)!";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:55:"!(?:v: ?"?|worldstar(?:hiphop)?\\.com/embed/)(?\'id\'\\d+)!";i:1;R:188;}}s:5:"match";a:1:{i:0;a:2:{i:0;s:54:"!worldstar(?:hiphop)?\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";i:1;R:219;}}}}}s:3:"wsj";a:2:{i:0;a:2:{i:0;a:2:{i:0;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:1;R:188;}i:1;a:2:{i:0;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";i:1;R:188;}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;R:1508;}s:5:"match";a:1:{i:0;a:2:{i:0;s:17:"@on\\.wsj\\.com/\\w@";i:1;R:219;}}}}}s:9:"xboxclips";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:92:"@(?:gameclips\\.io|xboxclips\\.com)/(?!game/)(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@";i:1;R:423;}}i:1;R:191;}s:7:"xboxdvr";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:62:"!(?:gamer|xbox)dvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";i:1;R:423;}}i:1;R:191;}s:7:"xenforo";a:2:{i:0;a:5:{i:0;a:2:{i:0;s:70:"!^(?\'url\'https://.*?/)media/albums/(?:[-\\w]+\\.)?(?\'xfmg_album_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"url";i:2;s:13:"xfmg_album_id";}}i:1;a:2:{i:0;s:95:"!^(?\'url\'https://.*?/)(?:members/[-.\\w]+/#profile-post-|profile-posts/)(?\'profile_post_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"url";i:2;s:15:"profile_post_id";}}i:2;a:2:{i:0;s:65:"!^(?\'url\'https://.*?/)resources/(?:[-\\w]+\\.)?(?\'resource_id\'\\d+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"url";i:2;s:11:"resource_id";}}i:3;a:2:{i:0;s:102:"!^(?\'url\'https://.*?/)threads/(?:[-\\w]+\\.)?(?\'thread_id\'\\d+)/(?:page-\\d+)?#?(?:post-(?\'post_id\'\\d+))?!";i:1;a:4:{i:0;s:0:"";i:1;s:3:"url";i:2;s:9:"thread_id";i:3;s:7:"post_id";}}i:4;a:2:{i:0;s:64:"!^(?\'url\'https://.*?/)embed\\.php\\?content=(?\'content_id\'[-\\w]+)!";i:1;a:3:{i:0;s:0:"";i:1;s:3:"url";i:2;s:10:"content_id";}}}i:1;R:191;}s:5:"youku";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:44:"!youku\\.com/v(?:_show|ideo)/id_(?\'id\'\\w+=*)!";i:1;R:188;}}i:1;R:191;}s:8:"youmaker";a:2:{i:0;a:1:{i:0;a:2:{i:0;s:55:"!youmaker\\.com/(?:embed|v(?:ideo)?)/(?\'id\'[-a-z0-9]+)!i";i:1;R:188;}}i:1;R:191;}s:7:"youtube";a:2:{i:0;a:5:{i:0;a:2:{i:0;s:91:"!youtube\\.com/(?:watch.*?v=|(?:embed|live|shorts|v)/|attribution_link.*?v%3D)(?\'id\'[-\\w]+)!";i:1;R:188;}i:1;a:2:{i:0;s:43:"!youtube-nocookie\\.com/embed/(?\'id\'[-\\w]+)!";i:1;R:188;}i:2;a:2:{i:0;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:1;R:188;}i:3;a:2:{i:0;s:42:"@[#&?]t(?:ime_continue)?=(?\'t\'\\d[\\dhms]*)@";i:1;R:448;}i:4;a:2:{i:0;s:26:"![&?]list=(?\'list\'[-\\w]+)!";i:1;a:2:{i:0;s:0:"";i:1;s:4:"list";}}}i:1;a:1:{i:0;a:2:{s:7:"extract";a:1:{i:0;a:2:{i:0;s:71:"@/embed/(?\'id\'[-\\w]+)\\?clip=(?\'clip\'[-\\w]+)&amp;clipt=(?\'clipt\'[-\\w]+)@";i:1;a:4:{i:0;s:0:"";i:1;s:2:"id";i:2;s:4:"clip";i:3;s:5:"clipt";}}}s:5:"match";a:1:{i:0;a:2:{i:0;s:21:"@youtube\\.com/clip/.@";i:1;R:219;}}}}}}}s:14:"' . "\0" . '*' . "\0" . 'rootContext";a:2:{s:7:"allowed";a:1:{i:0;i:771;}s:5:"flags";i:0;}s:13:"' . "\0" . '*' . "\0" . 'tagsConfig";a:133:{s:7:"ABCNEWS";a:7:{s:10:"attributes";a:1:{s:2:"id";a:2:{s:8:"required";b:0;s:11:"filterChain";R:191;}}s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\FilterProcessing::filterAttributes";s:6:"params";a:4:{s:3:"tag";N;s:9:"tagConfig";N;s:14:"registeredVars";N;s:6:"logger";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:3089;}s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";a:1:{i:0;i:256;}}s:5:"ACAST";a:7:{s:10:"attributes";a:3:{s:10:"episode_id";R:1600;s:7:"show_id";R:1600;s:1:"t";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"ANCHOR";R:1598;s:13:"APPLEPODCASTS";a:7:{s:10:"attributes";a:3:{s:7:"country";R:1600;s:10:"episode_id";R:1600;s:10:"podcast_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:9:"AUDIOBOOM";R:1598;s:9:"AUDIOMACK";a:7:{s:10:"attributes";a:3:{s:6:"artist";R:1600;s:4:"mode";R:1600;s:5:"title";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"AUDIUS";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1600;s:11:"playlist_id";R:1600;s:8:"track_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:8:"BANDCAMP";a:7:{s:10:"attributes";a:3:{s:8:"album_id";R:1600;s:8:"track_id";R:1600;s:9:"track_num";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:7:"BBCNEWS";R:1598;s:8:"BITCHUTE";R:1598;s:10:"BRIGHTCOVE";a:7:{s:10:"attributes";a:3:{s:5:"bckey";R:1600;s:5:"bcpid";R:1600;s:5:"bctid";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:5:"BUNNY";a:7:{s:10:"attributes";a:2:{s:8:"video_id";R:1600;s:16:"video_library_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:9:"CAPTIVATE";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1600;s:1:"t";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"CASTOS";a:7:{s:10:"attributes";a:2:{s:4:"host";R:1600;s:2:"id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:7:"CBSNEWS";R:1598;s:4:"CLYP";R:1598;s:4:"CNBC";R:1598;s:3:"CNN";R:1598;s:8:"CNNMONEY";R:1598;s:7:"CODEPEN";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1600;s:4:"user";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:13:"COMEDYCENTRAL";R:1598;s:4:"COUB";R:1598;s:11:"DAILYMOTION";R:1652;s:12:"DEMOCRACYNOW";R:1598;s:7:"DUMPERT";R:1598;s:11:"EIGHTTRACKS";R:1598;s:4:"ESPN";R:1598;s:8:"FACEBOOK";a:7:{s:10:"attributes";a:5:{s:2:"id";R:1600;s:7:"page_id";R:1600;s:5:"pfbid";R:1600;s:4:"type";R:1600;s:4:"user";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:7:"FALSTAD";a:7:{s:10:"attributes";a:2:{s:3:"cct";R:1600;s:3:"ctz";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"FLICKR";R:1598;s:7:"FOXNEWS";R:1598;s:10:"FUNNYORDIE";R:1598;s:8:"GAMESPOT";R:1598;s:5:"GETTY";a:7:{s:10:"attributes";a:5:{s:2:"et";a:2:{s:8:"required";b:1;s:11:"filterChain";R:191;}s:6:"height";a:3:{s:12:"defaultValue";i:360;s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:67:"s9e\\TextFormatter\\Parser\\AttributeFilters\\NumericFilter::filterUint";s:6:"params";a:1:{s:9:"attrValue";N;}}}s:8:"required";b:0;}s:2:"id";R:1600;s:3:"sig";R:1679;s:5:"width";a:3:{s:12:"defaultValue";i:640;s:11:"filterChain";R:1683;s:8:"required";b:0;}}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:4:"GIFS";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1681;s:2:"id";R:1600;s:5:"width";R:1689;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:5:"GIPHY";a:7:{s:10:"attributes";a:4:{s:6:"height";R:1681;s:2:"id";R:1600;s:4:"type";R:1600;s:5:"width";R:1689;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:4:"GIST";R:1598;s:10:"GLOBALNEWS";R:1598;s:8:"GOFUNDME";R:1598;s:11:"GOOGLEDRIVE";R:1598;s:10:"GOOGLEPLUS";a:7:{s:10:"attributes";a:3:{s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:9:"urldecode";s:6:"params";R:1686;}}s:8:"required";b:0;}s:3:"oid";R:1600;s:3:"pid";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:12:"GOOGLESHEETS";a:7:{s:10:"attributes";a:4:{s:3:"gid";R:1600;s:2:"id";R:1600;s:3:"oid";R:1600;s:4:"type";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:4:"HUDL";a:7:{s:10:"attributes";a:3:{s:7:"athlete";R:1600;s:9:"highlight";R:1600;s:2:"id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:4:"HULU";R:1598;s:3:"IGN";R:1598;s:4:"IMDB";R:1598;s:5:"IMGUR";R:1598;s:9:"INDIEGOGO";R:1598;s:9:"INSTAGRAM";R:1598;s:15:"INTERNETARCHIVE";a:7:{s:10:"attributes";a:3:{s:6:"height";R:1681;s:2:"id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:23:"htmlspecialchars_decode";s:6:"params";R:1686;}}s:8:"required";b:0;}s:5:"width";R:1689;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:8:"IZLESENE";R:1598;s:8:"JSFIDDLE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1600;s:8:"revision";R:1600;s:4:"user";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:10:"JWPLATFORM";R:1598;s:7:"KALTURA";a:7:{s:10:"attributes";a:4:{s:8:"entry_id";R:1679;s:10:"partner_id";R:1679;s:2:"sp";R:1600;s:9:"uiconf_id";R:1679;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:3:"KHL";R:1598;s:11:"KICKSTARTER";a:7:{s:10:"attributes";a:3:{s:4:"card";R:1600;s:2:"id";R:1600;s:5:"video";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"LIBSYN";R:1598;s:8:"LIVELEAK";R:1598;s:10:"LIVESTREAM";a:7:{s:10:"attributes";a:5:{s:10:"account_id";R:1600;s:7:"channel";R:1600;s:7:"clip_id";R:1600;s:8:"event_id";R:1600;s:8:"video_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"MAILRU";R:1598;s:8:"MASTODON";a:7:{s:10:"attributes";a:3:{s:4:"host";R:1679;s:2:"id";R:1600;s:4:"name";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:5:"MEDIA";a:7:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:54:"s9e\\TextFormatter\\Plugins\\MediaEmbed\\Parser::filterTag";s:6:"params";a:5:{s:3:"tag";N;s:6:"parser";N;s:16:"MediaEmbed.hosts";N;s:16:"MediaEmbed.sites";N;s:8:"cacheDir";N;}}}s:12:"nestingLimit";i:10;s:5:"rules";a:1:{s:5:"flags";i:513;}s:8:"tagLimit";i:5000;s:10:"attributes";R:191;s:9:"bitNumber";i:0;s:7:"allowed";a:1:{i:0;i:770;}}s:6:"MEDIUM";R:1598;s:9:"MEGAPHONE";R:1598;s:8:"METACAFE";R:1598;s:8:"MIXCLOUD";R:1598;s:3:"MLB";R:1598;s:5:"MRCTV";R:1598;s:5:"MSNBC";R:1598;s:13:"NATGEOCHANNEL";R:1598;s:11:"NATGEOVIDEO";R:1598;s:7:"NBCNEWS";R:1598;s:3:"NHL";a:7:{s:10:"attributes";a:2:{s:1:"c";R:1600;s:1:"t";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:3:"NPR";a:7:{s:10:"attributes";a:2:{s:1:"i";R:1600;s:1:"m";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:7:"NYTIMES";R:1598;s:6:"ODYSEE";a:7:{s:10:"attributes";a:3:{s:2:"id";R:1600;s:4:"name";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:59:"s9e\\TextFormatter\\Parser\\AttributeFilters\\UrlFilter::filter";s:6:"params";a:3:{s:9:"attrValue";N;s:9:"urlConfig";N;s:6:"logger";N;}}}s:8:"required";b:0;}s:4:"path";R:1789;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:3:"ON3";R:1598;s:6:"ORFIUM";a:7:{s:10:"attributes";a:4:{s:8:"album_id";R:1600;s:11:"playlist_id";R:1600;s:6:"set_id";R:1600;s:8:"track_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:8:"PASTEBIN";R:1598;s:9:"PINTEREST";R:1598;s:7:"PODBEAN";R:1598;s:5:"PREZI";R:1598;s:6:"REDDIT";R:1598;s:6:"RUMBLE";R:1598;s:6:"RUTUBE";R:1598;s:6:"SCRIBD";R:1598;s:7:"SENDVID";R:1598;s:10:"SLIDESHARE";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1600;s:3:"key";R:1679;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:10:"SOUNDCLOUD";a:7:{s:10:"attributes";a:4:{s:2:"id";R:1600;s:11:"playlist_id";R:1600;s:12:"secret_token";R:1600;s:8:"track_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:7:"SPORCLE";R:1598;s:9:"SPORTSNET";R:1598;s:7:"SPOTIFY";R:1598;s:8:"SPREAKER";a:7:{s:10:"attributes";a:2:{s:10:"episode_id";R:1600;s:7:"show_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:10:"STEAMSTORE";R:1598;s:9:"STRAWPOLL";R:1598;s:10:"STREAMABLE";R:1598;s:8:"TEAMCOCO";R:1598;s:3:"TED";R:1598;s:8:"TELEGRAM";R:1598;s:11:"THEATLANTIC";R:1598;s:11:"THEGUARDIAN";R:1598;s:8:"THEONION";R:1598;s:7:"THREADS";R:1598;s:6:"TIKTOK";R:1598;s:3:"TMZ";R:1598;s:11:"TRADINGVIEW";a:7:{s:10:"attributes";a:2:{s:5:"chart";R:1600;s:6:"symbol";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:13:"TRAILERADDICT";R:1598;s:13:"TRENDINGVIEWS";R:1598;s:6:"TUMBLR";a:7:{s:10:"attributes";a:4:{s:3:"did";R:1679;s:2:"id";R:1600;s:3:"key";R:1679;s:4:"name";R:1679;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:21:"TWENTYFOURSEVENSPORTS";a:7:{s:10:"attributes";a:1:{s:9:"player_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"TWITCH";a:7:{s:10:"attributes";a:4:{s:7:"channel";R:1600;s:7:"clip_id";R:1600;s:1:"t";R:1600;s:8:"video_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:7:"TWITTER";R:1598;s:7:"USTREAM";a:7:{s:10:"attributes";a:2:{s:3:"cid";R:1600;s:3:"vid";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:5:"VBOX7";R:1598;s:4:"VEOH";R:1598;s:4:"VEVO";R:1598;s:14:"VIDEODETECTIVE";R:1598;s:5:"VIMEO";a:7:{s:10:"attributes";a:3:{s:1:"h";R:1600;s:2:"id";R:1600;s:1:"t";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:65:"s9e\\TextFormatter\\Parser\\AttributeFilters\\TimestampFilter::filter";s:6:"params";R:1686;}}s:8:"required";b:0;}}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:4:"VINE";R:1598;s:2:"VK";a:7:{s:10:"attributes";a:3:{s:4:"hash";R:1600;s:3:"oid";R:1600;s:3:"vid";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:7:"VOCAROO";R:1598;s:3:"VOX";R:1598;s:14:"WASHINGTONPOST";R:1598;s:7:"WAVEKIT";a:7:{s:10:"attributes";a:2:{s:8:"audio_id";R:1600;s:11:"playlist_id";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:6:"WISTIA";a:7:{s:10:"attributes";a:2:{s:2:"id";R:1600;s:4:"type";R:1600;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:4:"WSHH";R:1598;s:3:"WSJ";R:1598;s:9:"XBOXCLIPS";R:1662;s:7:"XBOXDVR";R:1662;s:7:"XENFORO";a:7:{s:10:"attributes";a:7:{s:10:"content_id";a:2:{s:11:"filterChain";a:1:{i:0;a:2:{s:8:"callback";s:62:"s9e\\TextFormatter\\Parser\\AttributeFilters\\RegexpFilter::filter";s:6:"params";a:2:{s:9:"attrValue";N;i:0;s:19:"/^[-0-9A-Za-z_]+$/D";}}}s:8:"required";b:0;}s:7:"post_id";a:2:{s:11:"filterChain";R:1683;s:8:"required";b:0;}s:15:"profile_post_id";R:1881;s:11:"resource_id";R:1881;s:9:"thread_id";R:1881;s:3:"url";a:2:{s:11:"filterChain";R:1790;s:8:"required";b:1;}s:13:"xfmg_album_id";R:1881;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}s:5:"YOUKU";R:1598;s:8:"YOUMAKER";R:1598;s:7:"YOUTUBE";a:7:{s:10:"attributes";a:5:{s:4:"clip";R:1600;s:5:"clipt";R:1600;s:2:"id";R:1873;s:4:"list";R:1600;s:1:"t";R:1848;}s:11:"filterChain";R:1602;s:12:"nestingLimit";i:10;s:5:"rules";R:1611;s:8:"tagLimit";i:5000;s:9:"bitNumber";i:1;s:7:"allowed";R:1615;}}}');
	}

	/**
	* {@inheritdoc}
	*/
	public static function getRenderer(): \s9e\TextFormatter\Renderer
	{
		return unserialize('O:44:"s9e\\TextFormatter\\Bundles\\MediaPack\\Renderer":2:{s:19:"enableQuickRenderer";b:1;s:9:"' . "\0" . '*' . "\0" . 'params";a:1:{s:16:"MEDIAEMBED_THEME";s:0:"";}}');
	}
}