<?php

/*
 * This file is part of Flarum.
 *
 * For detailed copyright and license information, please view the
 * LICENSE file that was distributed with this source code.
 */

namespace Flarum\Extend;

use Flarum\Database\AbstractModel;
use Flarum\Extension\Extension;
use Illuminate\Contracts\Container\Container;
use Illuminate\Support\Arr;

class ModelUrl implements ExtenderInterface
{
    private array $slugDrivers = [];

    /**
     * @param class-string<AbstractModel> $modelClass: The ::class attribute of the model you are modifying.
     *                           This model should extend from \Flarum\Database\AbstractModel.
     */
    public function __construct(
        private readonly string $modelClass
    ) {
    }

    /**
     * Add a slug driver.
     *
     * @param string $identifier: Identifier for slug driver.
     * @param string $driver: ::class attribute of driver class, which must implement Flarum\Http\SlugDriverInterface.
     * @return self
     */
    public function addSlugDriver(string $identifier, string $driver): self
    {
        $this->slugDrivers[$identifier] = $driver;

        return $this;
    }

    public function extend(Container $container, ?Extension $extension = null): void
    {
        if ($this->slugDrivers) {
            $container->extend('flarum.http.slugDrivers', function ($existingDrivers) {
                $existingDrivers[$this->modelClass] = array_merge(Arr::get($existingDrivers, $this->modelClass, []), $this->slugDrivers);

                return $existingDrivers;
            });
        }
    }
}
