<?php

/*
 * This file is part of Flarum.
 *
 * For detailed copyright and license information, please view the
 * LICENSE file that was distributed with this source code.
 */

use Illuminate\Database\MySqlConnection;
use Illuminate\Database\Schema\Builder;

return [
    'up' => function (Builder $schema) {
        $connection = $schema->getConnection();

        if ($connection->getDriverName() instanceof MySqlConnection) {
            $prefix = $connection->getTablePrefix();
            $connection->statement('ALTER TABLE '.$prefix.'posts ENGINE = InnoDB');
        }
    },

    'down' => function (Builder $schema) {
        $connection = $schema->getConnection();

        if ($connection->getDriverName() instanceof MySqlConnection) {
            $prefix = $connection->getTablePrefix();
            $connection->statement('ALTER TABLE '.$prefix.'posts ENGINE = MyISAM');
        }
    }
];
